package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.Uri
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Transcript(
    transcriptFileUri: Optional[Uri] = Optional.Absent,
    redactedTranscriptFileUri: Optional[Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.Transcript = {
    import Transcript.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.Transcript
      .builder()
      .optionallyWith(
        transcriptFileUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.transcriptFileUri)
      .optionallyWith(
        redactedTranscriptFileUri.map(value =>
          Uri.unwrap(value): java.lang.String
        )
      )(_.redactedTranscriptFileUri)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.Transcript.ReadOnly =
    zio.aws.transcribe.model.Transcript.wrap(buildAwsValue())
}
object Transcript {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.Transcript
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.Transcript =
      zio.aws.transcribe.model.Transcript(
        transcriptFileUri.map(value => value),
        redactedTranscriptFileUri.map(value => value)
      )
    def transcriptFileUri: Optional[Uri]
    def redactedTranscriptFileUri: Optional[Uri]
    def getTranscriptFileUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("transcriptFileUri", transcriptFileUri)
    def getRedactedTranscriptFileUri: ZIO[Any, AwsError, Uri] = AwsError
      .unwrapOptionField("redactedTranscriptFileUri", redactedTranscriptFileUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.Transcript
  ) extends zio.aws.transcribe.model.Transcript.ReadOnly {
    override val transcriptFileUri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.transcriptFileUri())
      .map(value => zio.aws.transcribe.model.primitives.Uri(value))
    override val redactedTranscriptFileUri: Optional[Uri] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redactedTranscriptFileUri())
        .map(value => zio.aws.transcribe.model.primitives.Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.Transcript
  ): zio.aws.transcribe.model.Transcript.ReadOnly = new Wrapper(impl)
}
