package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ToxicityDetectionSettings(
    toxicityCategories: Iterable[zio.aws.transcribe.model.ToxicityCategory]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ToxicityDetectionSettings = {
    import ToxicityDetectionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ToxicityDetectionSettings
      .builder()
      .toxicityCategoriesWithStrings(toxicityCategories.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.ToxicityDetectionSettings.ReadOnly =
    zio.aws.transcribe.model.ToxicityDetectionSettings.wrap(buildAwsValue())
}
object ToxicityDetectionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ToxicityDetectionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ToxicityDetectionSettings =
      zio.aws.transcribe.model.ToxicityDetectionSettings(toxicityCategories)
    def toxicityCategories: List[zio.aws.transcribe.model.ToxicityCategory]
    def getToxicityCategories
        : ZIO[Any, Nothing, List[zio.aws.transcribe.model.ToxicityCategory]] =
      ZIO.succeed(toxicityCategories)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ToxicityDetectionSettings
  ) extends zio.aws.transcribe.model.ToxicityDetectionSettings.ReadOnly {
    override val toxicityCategories
        : List[zio.aws.transcribe.model.ToxicityCategory] = impl
      .toxicityCategories()
      .asScala
      .map { item =>
        zio.aws.transcribe.model.ToxicityCategory.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ToxicityDetectionSettings
  ): zio.aws.transcribe.model.ToxicityDetectionSettings.ReadOnly = new Wrapper(
    impl
  )
}
