package zio.aws.transcribe.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{
  OutputBucketName,
  MediaSampleRateHertz,
  OutputKey,
  NonEmptyString,
  TranscriptionJobName,
  KMSKeyId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class StartTranscriptionJobRequest(
    transcriptionJobName: TranscriptionJobName,
    languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      Optional.Absent,
    mediaSampleRateHertz: Optional[MediaSampleRateHertz] = Optional.Absent,
    mediaFormat: Optional[zio.aws.transcribe.model.MediaFormat] =
      Optional.Absent,
    media: zio.aws.transcribe.model.Media,
    outputBucketName: Optional[OutputBucketName] = Optional.Absent,
    outputKey: Optional[OutputKey] = Optional.Absent,
    outputEncryptionKMSKeyId: Optional[KMSKeyId] = Optional.Absent,
    kmsEncryptionContext: Optional[Map[NonEmptyString, NonEmptyString]] =
      Optional.Absent,
    settings: Optional[zio.aws.transcribe.model.Settings] = Optional.Absent,
    modelSettings: Optional[zio.aws.transcribe.model.ModelSettings] =
      Optional.Absent,
    jobExecutionSettings: Optional[
      zio.aws.transcribe.model.JobExecutionSettings
    ] = Optional.Absent,
    contentRedaction: Optional[zio.aws.transcribe.model.ContentRedaction] =
      Optional.Absent,
    identifyLanguage: Optional[Boolean] = Optional.Absent,
    identifyMultipleLanguages: Optional[Boolean] = Optional.Absent,
    languageOptions: Optional[Iterable[zio.aws.transcribe.model.LanguageCode]] =
      Optional.Absent,
    subtitles: Optional[zio.aws.transcribe.model.Subtitles] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.transcribe.model.Tag]] = Optional.Absent,
    languageIdSettings: Optional[Map[
      zio.aws.transcribe.model.LanguageCode,
      zio.aws.transcribe.model.LanguageIdSettings
    ]] = Optional.Absent,
    toxicityDetection: Optional[
      Iterable[zio.aws.transcribe.model.ToxicityDetectionSettings]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobRequest = {
    import StartTranscriptionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobRequest
      .builder()
      .transcriptionJobName(
        TranscriptionJobName.unwrap(transcriptionJobName): java.lang.String
      )
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        mediaSampleRateHertz.map(value =>
          MediaSampleRateHertz.unwrap(value): Integer
        )
      )(_.mediaSampleRateHertz)
      .optionallyWith(mediaFormat.map(value => value.unwrap))(_.mediaFormat)
      .media(media.buildAwsValue())
      .optionallyWith(
        outputBucketName.map(value =>
          OutputBucketName.unwrap(value): java.lang.String
        )
      )(_.outputBucketName)
      .optionallyWith(
        outputKey.map(value => OutputKey.unwrap(value): java.lang.String)
      )(_.outputKey)
      .optionallyWith(
        outputEncryptionKMSKeyId.map(value =>
          KMSKeyId.unwrap(value): java.lang.String
        )
      )(_.outputEncryptionKMSKeyId)
      .optionallyWith(
        kmsEncryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.kmsEncryptionContext)
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .optionallyWith(modelSettings.map(value => value.buildAwsValue()))(
        _.modelSettings
      )
      .optionallyWith(jobExecutionSettings.map(value => value.buildAwsValue()))(
        _.jobExecutionSettings
      )
      .optionallyWith(contentRedaction.map(value => value.buildAwsValue()))(
        _.contentRedaction
      )
      .optionallyWith(identifyLanguage.map(value => value: java.lang.Boolean))(
        _.identifyLanguage
      )
      .optionallyWith(
        identifyMultipleLanguages.map(value => value: java.lang.Boolean)
      )(_.identifyMultipleLanguages)
      .optionallyWith(
        languageOptions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.languageOptionsWithStrings)
      .optionallyWith(subtitles.map(value => value.buildAwsValue()))(
        _.subtitles
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        languageIdSettings.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.languageIdSettingsWithStrings)
      .optionallyWith(
        toxicityDetection.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.toxicityDetection)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.StartTranscriptionJobRequest.ReadOnly =
    zio.aws.transcribe.model.StartTranscriptionJobRequest.wrap(buildAwsValue())
}
object StartTranscriptionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.StartTranscriptionJobRequest =
      zio.aws.transcribe.model.StartTranscriptionJobRequest(
        transcriptionJobName,
        languageCode.map(value => value),
        mediaSampleRateHertz.map(value => value),
        mediaFormat.map(value => value),
        media.asEditable,
        outputBucketName.map(value => value),
        outputKey.map(value => value),
        outputEncryptionKMSKeyId.map(value => value),
        kmsEncryptionContext.map(value => value),
        settings.map(value => value.asEditable),
        modelSettings.map(value => value.asEditable),
        jobExecutionSettings.map(value => value.asEditable),
        contentRedaction.map(value => value.asEditable),
        identifyLanguage.map(value => value),
        identifyMultipleLanguages.map(value => value),
        languageOptions.map(value => value),
        subtitles.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        languageIdSettings.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        toxicityDetection.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transcriptionJobName: TranscriptionJobName
    def languageCode: Optional[zio.aws.transcribe.model.LanguageCode]
    def mediaSampleRateHertz: Optional[MediaSampleRateHertz]
    def mediaFormat: Optional[zio.aws.transcribe.model.MediaFormat]
    def media: zio.aws.transcribe.model.Media.ReadOnly
    def outputBucketName: Optional[OutputBucketName]
    def outputKey: Optional[OutputKey]
    def outputEncryptionKMSKeyId: Optional[KMSKeyId]
    def kmsEncryptionContext: Optional[Map[NonEmptyString, NonEmptyString]]
    def settings: Optional[zio.aws.transcribe.model.Settings.ReadOnly]
    def modelSettings: Optional[zio.aws.transcribe.model.ModelSettings.ReadOnly]
    def jobExecutionSettings
        : Optional[zio.aws.transcribe.model.JobExecutionSettings.ReadOnly]
    def contentRedaction
        : Optional[zio.aws.transcribe.model.ContentRedaction.ReadOnly]
    def identifyLanguage: Optional[Boolean]
    def identifyMultipleLanguages: Optional[Boolean]
    def languageOptions: Optional[List[zio.aws.transcribe.model.LanguageCode]]
    def subtitles: Optional[zio.aws.transcribe.model.Subtitles.ReadOnly]
    def tags: Optional[List[zio.aws.transcribe.model.Tag.ReadOnly]]
    def languageIdSettings: Optional[Map[
      zio.aws.transcribe.model.LanguageCode,
      zio.aws.transcribe.model.LanguageIdSettings.ReadOnly
    ]]
    def toxicityDetection: Optional[
      List[zio.aws.transcribe.model.ToxicityDetectionSettings.ReadOnly]
    ]
    def getTranscriptionJobName: ZIO[Any, Nothing, TranscriptionJobName] =
      ZIO.succeed(transcriptionJobName)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getMediaSampleRateHertz: ZIO[Any, AwsError, MediaSampleRateHertz] =
      AwsError.unwrapOptionField("mediaSampleRateHertz", mediaSampleRateHertz)
    def getMediaFormat
        : ZIO[Any, AwsError, zio.aws.transcribe.model.MediaFormat] =
      AwsError.unwrapOptionField("mediaFormat", mediaFormat)
    def getMedia: ZIO[Any, Nothing, zio.aws.transcribe.model.Media.ReadOnly] =
      ZIO.succeed(media)
    def getOutputBucketName: ZIO[Any, AwsError, OutputBucketName] =
      AwsError.unwrapOptionField("outputBucketName", outputBucketName)
    def getOutputKey: ZIO[Any, AwsError, OutputKey] =
      AwsError.unwrapOptionField("outputKey", outputKey)
    def getOutputEncryptionKMSKeyId: ZIO[Any, AwsError, KMSKeyId] = AwsError
      .unwrapOptionField("outputEncryptionKMSKeyId", outputEncryptionKMSKeyId)
    def getKmsEncryptionContext
        : ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("kmsEncryptionContext", kmsEncryptionContext)
    def getSettings
        : ZIO[Any, AwsError, zio.aws.transcribe.model.Settings.ReadOnly] =
      AwsError.unwrapOptionField("settings", settings)
    def getModelSettings
        : ZIO[Any, AwsError, zio.aws.transcribe.model.ModelSettings.ReadOnly] =
      AwsError.unwrapOptionField("modelSettings", modelSettings)
    def getJobExecutionSettings: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.JobExecutionSettings.ReadOnly
    ] = AwsError.unwrapOptionField("jobExecutionSettings", jobExecutionSettings)
    def getContentRedaction: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.ContentRedaction.ReadOnly
    ] = AwsError.unwrapOptionField("contentRedaction", contentRedaction)
    def getIdentifyLanguage: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("identifyLanguage", identifyLanguage)
    def getIdentifyMultipleLanguages: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("identifyMultipleLanguages", identifyMultipleLanguages)
    def getLanguageOptions
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.LanguageCode]] =
      AwsError.unwrapOptionField("languageOptions", languageOptions)
    def getSubtitles
        : ZIO[Any, AwsError, zio.aws.transcribe.model.Subtitles.ReadOnly] =
      AwsError.unwrapOptionField("subtitles", subtitles)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getLanguageIdSettings: ZIO[Any, AwsError, Map[
      zio.aws.transcribe.model.LanguageCode,
      zio.aws.transcribe.model.LanguageIdSettings.ReadOnly
    ]] = AwsError.unwrapOptionField("languageIdSettings", languageIdSettings)
    def getToxicityDetection: ZIO[Any, AwsError, List[
      zio.aws.transcribe.model.ToxicityDetectionSettings.ReadOnly
    ]] = AwsError.unwrapOptionField("toxicityDetection", toxicityDetection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobRequest
  ) extends zio.aws.transcribe.model.StartTranscriptionJobRequest.ReadOnly {
    override val transcriptionJobName: TranscriptionJobName =
      zio.aws.transcribe.model.primitives
        .TranscriptionJobName(impl.transcriptionJobName())
    override val languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.transcribe.model.LanguageCode.wrap(value))
    override val mediaSampleRateHertz: Optional[MediaSampleRateHertz] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaSampleRateHertz())
        .map(value =>
          zio.aws.transcribe.model.primitives.MediaSampleRateHertz(value)
        )
    override val mediaFormat: Optional[zio.aws.transcribe.model.MediaFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaFormat())
        .map(value => zio.aws.transcribe.model.MediaFormat.wrap(value))
    override val media: zio.aws.transcribe.model.Media.ReadOnly =
      zio.aws.transcribe.model.Media.wrap(impl.media())
    override val outputBucketName: Optional[OutputBucketName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputBucketName())
        .map(value =>
          zio.aws.transcribe.model.primitives.OutputBucketName(value)
        )
    override val outputKey: Optional[OutputKey] = zio.aws.core.internal
      .optionalFromNullable(impl.outputKey())
      .map(value => zio.aws.transcribe.model.primitives.OutputKey(value))
    override val outputEncryptionKMSKeyId: Optional[KMSKeyId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputEncryptionKMSKeyId())
        .map(value => zio.aws.transcribe.model.primitives.KMSKeyId(value))
    override val kmsEncryptionContext
        : Optional[Map[NonEmptyString, NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsEncryptionContext())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.transcribe.model.primitives.NonEmptyString(
              key
            ) -> zio.aws.transcribe.model.primitives.NonEmptyString(value)
          })
          .toMap
      )
    override val settings
        : Optional[zio.aws.transcribe.model.Settings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.settings())
        .map(value => zio.aws.transcribe.model.Settings.wrap(value))
    override val modelSettings
        : Optional[zio.aws.transcribe.model.ModelSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelSettings())
        .map(value => zio.aws.transcribe.model.ModelSettings.wrap(value))
    override val jobExecutionSettings
        : Optional[zio.aws.transcribe.model.JobExecutionSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobExecutionSettings())
        .map(value => zio.aws.transcribe.model.JobExecutionSettings.wrap(value))
    override val contentRedaction
        : Optional[zio.aws.transcribe.model.ContentRedaction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentRedaction())
        .map(value => zio.aws.transcribe.model.ContentRedaction.wrap(value))
    override val identifyLanguage: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.identifyLanguage())
      .map(value => value: Boolean)
    override val identifyMultipleLanguages: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identifyMultipleLanguages())
        .map(value => value: Boolean)
    override val languageOptions
        : Optional[List[zio.aws.transcribe.model.LanguageCode]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.LanguageCode.wrap(item)
          }.toList
        )
    override val subtitles
        : Optional[zio.aws.transcribe.model.Subtitles.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subtitles())
        .map(value => zio.aws.transcribe.model.Subtitles.wrap(value))
    override val tags: Optional[List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.Tag.wrap(item)
          }.toList
        )
    override val languageIdSettings: Optional[Map[
      zio.aws.transcribe.model.LanguageCode,
      zio.aws.transcribe.model.LanguageIdSettings.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.languageIdSettings())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.transcribe.model.LanguageCode.wrap(
              key
            ) -> zio.aws.transcribe.model.LanguageIdSettings.wrap(value)
          })
          .toMap
      )
    override val toxicityDetection: Optional[
      List[zio.aws.transcribe.model.ToxicityDetectionSettings.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.toxicityDetection())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribe.model.ToxicityDetectionSettings.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobRequest
  ): zio.aws.transcribe.model.StartTranscriptionJobRequest.ReadOnly =
    new Wrapper(impl)
}
