package zio.aws.transcribe.model
import scala.jdk.CollectionConverters.*
sealed trait RedactionType {
  def unwrap: software.amazon.awssdk.services.transcribe.model.RedactionType
}
object RedactionType {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.RedactionType
  ): zio.aws.transcribe.model.RedactionType = value match {
    case software.amazon.awssdk.services.transcribe.model.RedactionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.RedactionType.PII =>
      val r = PII
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribe.model.RedactionType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.RedactionType =
      software.amazon.awssdk.services.transcribe.model.RedactionType.UNKNOWN_TO_SDK_VERSION
  }
  case object PII extends zio.aws.transcribe.model.RedactionType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.RedactionType =
      software.amazon.awssdk.services.transcribe.model.RedactionType.PII
  }
}
