package zio.aws.transcribe.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{
  FailureReason,
  DateTime,
  MedicalMediaSampleRateHertz,
  TranscriptionJobName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class MedicalTranscriptionJob(
    medicalTranscriptionJobName: Optional[TranscriptionJobName] =
      Optional.Absent,
    transcriptionJobStatus: Optional[
      zio.aws.transcribe.model.TranscriptionJobStatus
    ] = Optional.Absent,
    languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      Optional.Absent,
    mediaSampleRateHertz: Optional[MedicalMediaSampleRateHertz] =
      Optional.Absent,
    mediaFormat: Optional[zio.aws.transcribe.model.MediaFormat] =
      Optional.Absent,
    media: Optional[zio.aws.transcribe.model.Media] = Optional.Absent,
    transcript: Optional[zio.aws.transcribe.model.MedicalTranscript] =
      Optional.Absent,
    startTime: Optional[DateTime] = Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    completionTime: Optional[DateTime] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    settings: Optional[zio.aws.transcribe.model.MedicalTranscriptionSetting] =
      Optional.Absent,
    contentIdentificationType: Optional[
      zio.aws.transcribe.model.MedicalContentIdentificationType
    ] = Optional.Absent,
    specialty: Optional[zio.aws.transcribe.model.Specialty] = Optional.Absent,
    `type`: Optional[zio.aws.transcribe.model.Type] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.transcribe.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJob = {
    import MedicalTranscriptionJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJob
      .builder()
      .optionallyWith(
        medicalTranscriptionJobName.map(value =>
          TranscriptionJobName.unwrap(value): java.lang.String
        )
      )(_.medicalTranscriptionJobName)
      .optionallyWith(transcriptionJobStatus.map(value => value.unwrap))(
        _.transcriptionJobStatus
      )
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        mediaSampleRateHertz.map(value =>
          MedicalMediaSampleRateHertz.unwrap(value): Integer
        )
      )(_.mediaSampleRateHertz)
      .optionallyWith(mediaFormat.map(value => value.unwrap))(_.mediaFormat)
      .optionallyWith(media.map(value => value.buildAwsValue()))(_.media)
      .optionallyWith(transcript.map(value => value.buildAwsValue()))(
        _.transcript
      )
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        completionTime.map(value => DateTime.unwrap(value): Instant)
      )(_.completionTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .optionallyWith(contentIdentificationType.map(value => value.unwrap))(
        _.contentIdentificationType
      )
      .optionallyWith(specialty.map(value => value.unwrap))(_.specialty)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.MedicalTranscriptionJob.ReadOnly =
    zio.aws.transcribe.model.MedicalTranscriptionJob.wrap(buildAwsValue())
}
object MedicalTranscriptionJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.MedicalTranscriptionJob =
      zio.aws.transcribe.model.MedicalTranscriptionJob(
        medicalTranscriptionJobName.map(value => value),
        transcriptionJobStatus.map(value => value),
        languageCode.map(value => value),
        mediaSampleRateHertz.map(value => value),
        mediaFormat.map(value => value),
        media.map(value => value.asEditable),
        transcript.map(value => value.asEditable),
        startTime.map(value => value),
        creationTime.map(value => value),
        completionTime.map(value => value),
        failureReason.map(value => value),
        settings.map(value => value.asEditable),
        contentIdentificationType.map(value => value),
        specialty.map(value => value),
        `type`.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def medicalTranscriptionJobName: Optional[TranscriptionJobName]
    def transcriptionJobStatus
        : Optional[zio.aws.transcribe.model.TranscriptionJobStatus]
    def languageCode: Optional[zio.aws.transcribe.model.LanguageCode]
    def mediaSampleRateHertz: Optional[MedicalMediaSampleRateHertz]
    def mediaFormat: Optional[zio.aws.transcribe.model.MediaFormat]
    def media: Optional[zio.aws.transcribe.model.Media.ReadOnly]
    def transcript
        : Optional[zio.aws.transcribe.model.MedicalTranscript.ReadOnly]
    def startTime: Optional[DateTime]
    def creationTime: Optional[DateTime]
    def completionTime: Optional[DateTime]
    def failureReason: Optional[FailureReason]
    def settings: Optional[
      zio.aws.transcribe.model.MedicalTranscriptionSetting.ReadOnly
    ]
    def contentIdentificationType
        : Optional[zio.aws.transcribe.model.MedicalContentIdentificationType]
    def specialty: Optional[zio.aws.transcribe.model.Specialty]
    def `type`: Optional[zio.aws.transcribe.model.Type]
    def tags: Optional[List[zio.aws.transcribe.model.Tag.ReadOnly]]
    def getMedicalTranscriptionJobName
        : ZIO[Any, AwsError, TranscriptionJobName] = AwsError.unwrapOptionField(
      "medicalTranscriptionJobName",
      medicalTranscriptionJobName
    )
    def getTranscriptionJobStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.TranscriptionJobStatus] =
      AwsError.unwrapOptionField(
        "transcriptionJobStatus",
        transcriptionJobStatus
      )
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getMediaSampleRateHertz
        : ZIO[Any, AwsError, MedicalMediaSampleRateHertz] =
      AwsError.unwrapOptionField("mediaSampleRateHertz", mediaSampleRateHertz)
    def getMediaFormat
        : ZIO[Any, AwsError, zio.aws.transcribe.model.MediaFormat] =
      AwsError.unwrapOptionField("mediaFormat", mediaFormat)
    def getMedia: ZIO[Any, AwsError, zio.aws.transcribe.model.Media.ReadOnly] =
      AwsError.unwrapOptionField("media", media)
    def getTranscript: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.MedicalTranscript.ReadOnly
    ] = AwsError.unwrapOptionField("transcript", transcript)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCompletionTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getSettings: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.MedicalTranscriptionSetting.ReadOnly
    ] = AwsError.unwrapOptionField("settings", settings)
    def getContentIdentificationType: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.MedicalContentIdentificationType
    ] = AwsError.unwrapOptionField(
      "contentIdentificationType",
      contentIdentificationType
    )
    def getSpecialty: ZIO[Any, AwsError, zio.aws.transcribe.model.Specialty] =
      AwsError.unwrapOptionField("specialty", specialty)
    def getType: ZIO[Any, AwsError, zio.aws.transcribe.model.Type] =
      AwsError.unwrapOptionField("type", `type`)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJob
  ) extends zio.aws.transcribe.model.MedicalTranscriptionJob.ReadOnly {
    override val medicalTranscriptionJobName: Optional[TranscriptionJobName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.medicalTranscriptionJobName())
        .map(value =>
          zio.aws.transcribe.model.primitives.TranscriptionJobName(value)
        )
    override val transcriptionJobStatus
        : Optional[zio.aws.transcribe.model.TranscriptionJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transcriptionJobStatus())
        .map(value =>
          zio.aws.transcribe.model.TranscriptionJobStatus.wrap(value)
        )
    override val languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.transcribe.model.LanguageCode.wrap(value))
    override val mediaSampleRateHertz: Optional[MedicalMediaSampleRateHertz] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaSampleRateHertz())
        .map(value =>
          zio.aws.transcribe.model.primitives.MedicalMediaSampleRateHertz(value)
        )
    override val mediaFormat: Optional[zio.aws.transcribe.model.MediaFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaFormat())
        .map(value => zio.aws.transcribe.model.MediaFormat.wrap(value))
    override val media: Optional[zio.aws.transcribe.model.Media.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.media())
        .map(value => zio.aws.transcribe.model.Media.wrap(value))
    override val transcript
        : Optional[zio.aws.transcribe.model.MedicalTranscript.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transcript())
        .map(value => zio.aws.transcribe.model.MedicalTranscript.wrap(value))
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val completionTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.completionTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.transcribe.model.primitives.FailureReason(value))
    override val settings: Optional[
      zio.aws.transcribe.model.MedicalTranscriptionSetting.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.settings())
      .map(value =>
        zio.aws.transcribe.model.MedicalTranscriptionSetting.wrap(value)
      )
    override val contentIdentificationType
        : Optional[zio.aws.transcribe.model.MedicalContentIdentificationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentIdentificationType())
        .map(value =>
          zio.aws.transcribe.model.MedicalContentIdentificationType.wrap(value)
        )
    override val specialty: Optional[zio.aws.transcribe.model.Specialty] =
      zio.aws.core.internal
        .optionalFromNullable(impl.specialty())
        .map(value => zio.aws.transcribe.model.Specialty.wrap(value))
    override val `type`: Optional[zio.aws.transcribe.model.Type] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.transcribe.model.Type.wrap(value))
    override val tags: Optional[List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJob
  ): zio.aws.transcribe.model.MedicalTranscriptionJob.ReadOnly = new Wrapper(
    impl
  )
}
