package zio.aws.transcribe.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{
  VocabularyName,
  MaxResults,
  NextToken
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListMedicalVocabulariesRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    stateEquals: Optional[zio.aws.transcribe.model.VocabularyState] =
      Optional.Absent,
    nameContains: Optional[VocabularyName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest = {
    import ListMedicalVocabulariesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(stateEquals.map(value => value.unwrap))(_.stateEquals)
      .optionallyWith(
        nameContains.map(value =>
          VocabularyName.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.ListMedicalVocabulariesRequest.ReadOnly =
    zio.aws.transcribe.model.ListMedicalVocabulariesRequest
      .wrap(buildAwsValue())
}
object ListMedicalVocabulariesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ListMedicalVocabulariesRequest =
      zio.aws.transcribe.model.ListMedicalVocabulariesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        stateEquals.map(value => value),
        nameContains.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def stateEquals: Optional[zio.aws.transcribe.model.VocabularyState]
    def nameContains: Optional[VocabularyName]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStateEquals
        : ZIO[Any, AwsError, zio.aws.transcribe.model.VocabularyState] =
      AwsError.unwrapOptionField("stateEquals", stateEquals)
    def getNameContains: ZIO[Any, AwsError, VocabularyName] =
      AwsError.unwrapOptionField("nameContains", nameContains)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest
  ) extends zio.aws.transcribe.model.ListMedicalVocabulariesRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transcribe.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.transcribe.model.primitives.MaxResults(value))
    override val stateEquals
        : Optional[zio.aws.transcribe.model.VocabularyState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateEquals())
        .map(value => zio.aws.transcribe.model.VocabularyState.wrap(value))
    override val nameContains: Optional[VocabularyName] = zio.aws.core.internal
      .optionalFromNullable(impl.nameContains())
      .map(value => zio.aws.transcribe.model.primitives.VocabularyName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest
  ): zio.aws.transcribe.model.ListMedicalVocabulariesRequest.ReadOnly =
    new Wrapper(impl)
}
