package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListLanguageModelsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    models: Optional[Iterable[zio.aws.transcribe.model.LanguageModel]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse = {
    import ListLanguageModelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        models.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.models)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.ListLanguageModelsResponse.ReadOnly =
    zio.aws.transcribe.model.ListLanguageModelsResponse.wrap(buildAwsValue())
}
object ListLanguageModelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ListLanguageModelsResponse =
      zio.aws.transcribe.model.ListLanguageModelsResponse(
        nextToken.map(value => value),
        models.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def models: Optional[List[zio.aws.transcribe.model.LanguageModel.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getModels: ZIO[Any, AwsError, List[
      zio.aws.transcribe.model.LanguageModel.ReadOnly
    ]] = AwsError.unwrapOptionField("models", models)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse
  ) extends zio.aws.transcribe.model.ListLanguageModelsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transcribe.model.primitives.NextToken(value))
    override val models
        : Optional[List[zio.aws.transcribe.model.LanguageModel.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.models())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.LanguageModel.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse
  ): zio.aws.transcribe.model.ListLanguageModelsResponse.ReadOnly = new Wrapper(
    impl
  )
}
