package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.VocabularyName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteVocabularyRequest(vocabularyName: VocabularyName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.DeleteVocabularyRequest = {
    import DeleteVocabularyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.DeleteVocabularyRequest
      .builder()
      .vocabularyName(VocabularyName.unwrap(vocabularyName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.DeleteVocabularyRequest.ReadOnly =
    zio.aws.transcribe.model.DeleteVocabularyRequest.wrap(buildAwsValue())
}
object DeleteVocabularyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.DeleteVocabularyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.DeleteVocabularyRequest =
      zio.aws.transcribe.model.DeleteVocabularyRequest(vocabularyName)
    def vocabularyName: VocabularyName
    def getVocabularyName: ZIO[Any, Nothing, VocabularyName] =
      ZIO.succeed(vocabularyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.DeleteVocabularyRequest
  ) extends zio.aws.transcribe.model.DeleteVocabularyRequest.ReadOnly {
    override val vocabularyName: VocabularyName =
      zio.aws.transcribe.model.primitives.VocabularyName(impl.vocabularyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.DeleteVocabularyRequest
  ): zio.aws.transcribe.model.DeleteVocabularyRequest.ReadOnly = new Wrapper(
    impl
  )
}
