package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.DurationInSeconds
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LanguageCodeItem(
    languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      Optional.Absent,
    durationInSeconds: Optional[DurationInSeconds] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.LanguageCodeItem = {
    import LanguageCodeItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.LanguageCodeItem
      .builder()
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        durationInSeconds.map(value =>
          DurationInSeconds.unwrap(value): java.lang.Float
        )
      )(_.durationInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.LanguageCodeItem.ReadOnly =
    zio.aws.transcribe.model.LanguageCodeItem.wrap(buildAwsValue())
}
object LanguageCodeItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.LanguageCodeItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.LanguageCodeItem =
      zio.aws.transcribe.model.LanguageCodeItem(
        languageCode.map(value => value),
        durationInSeconds.map(value => value)
      )
    def languageCode: Optional[zio.aws.transcribe.model.LanguageCode]
    def durationInSeconds: Optional[DurationInSeconds]
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getDurationInSeconds: ZIO[Any, AwsError, DurationInSeconds] =
      AwsError.unwrapOptionField("durationInSeconds", durationInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.LanguageCodeItem
  ) extends zio.aws.transcribe.model.LanguageCodeItem.ReadOnly {
    override val languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.transcribe.model.LanguageCode.wrap(value))
    override val durationInSeconds: Optional[DurationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationInSeconds())
        .map(value =>
          zio.aws.transcribe.model.primitives.DurationInSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.LanguageCodeItem
  ): zio.aws.transcribe.model.LanguageCodeItem.ReadOnly = new Wrapper(impl)
}
