package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetMedicalTranscriptionJobResponse(
    medicalTranscriptionJob: Optional[
      zio.aws.transcribe.model.MedicalTranscriptionJob
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobResponse = {
    import GetMedicalTranscriptionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobResponse
      .builder()
      .optionallyWith(
        medicalTranscriptionJob.map(value => value.buildAwsValue())
      )(_.medicalTranscriptionJob)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.GetMedicalTranscriptionJobResponse.ReadOnly =
    zio.aws.transcribe.model.GetMedicalTranscriptionJobResponse
      .wrap(buildAwsValue())
}
object GetMedicalTranscriptionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.transcribe.model.GetMedicalTranscriptionJobResponse =
      zio.aws.transcribe.model.GetMedicalTranscriptionJobResponse(
        medicalTranscriptionJob.map(value => value.asEditable)
      )
    def medicalTranscriptionJob
        : Optional[zio.aws.transcribe.model.MedicalTranscriptionJob.ReadOnly]
    def getMedicalTranscriptionJob: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.MedicalTranscriptionJob.ReadOnly
    ] = AwsError.unwrapOptionField(
      "medicalTranscriptionJob",
      medicalTranscriptionJob
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobResponse
  ) extends zio.aws.transcribe.model.GetMedicalTranscriptionJobResponse.ReadOnly {
    override val medicalTranscriptionJob
        : Optional[zio.aws.transcribe.model.MedicalTranscriptionJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.medicalTranscriptionJob())
        .map(value =>
          zio.aws.transcribe.model.MedicalTranscriptionJob.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobResponse
  ): zio.aws.transcribe.model.GetMedicalTranscriptionJobResponse.ReadOnly =
    new Wrapper(impl)
}
