package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.{
  ModelName,
  VocabularyFilterName,
  VocabularyName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LanguageIdSettings(
    vocabularyName: Optional[VocabularyName] = Optional.Absent,
    vocabularyFilterName: Optional[VocabularyFilterName] = Optional.Absent,
    languageModelName: Optional[ModelName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.LanguageIdSettings = {
    import LanguageIdSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.LanguageIdSettings
      .builder()
      .optionallyWith(
        vocabularyName.map(value =>
          VocabularyName.unwrap(value): java.lang.String
        )
      )(_.vocabularyName)
      .optionallyWith(
        vocabularyFilterName.map(value =>
          VocabularyFilterName.unwrap(value): java.lang.String
        )
      )(_.vocabularyFilterName)
      .optionallyWith(
        languageModelName.map(value =>
          ModelName.unwrap(value): java.lang.String
        )
      )(_.languageModelName)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.LanguageIdSettings.ReadOnly =
    zio.aws.transcribe.model.LanguageIdSettings.wrap(buildAwsValue())
}
object LanguageIdSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.LanguageIdSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.LanguageIdSettings =
      zio.aws.transcribe.model.LanguageIdSettings(
        vocabularyName.map(value => value),
        vocabularyFilterName.map(value => value),
        languageModelName.map(value => value)
      )
    def vocabularyName: Optional[VocabularyName]
    def vocabularyFilterName: Optional[VocabularyFilterName]
    def languageModelName: Optional[ModelName]
    def getVocabularyName: ZIO[Any, AwsError, VocabularyName] =
      AwsError.unwrapOptionField("vocabularyName", vocabularyName)
    def getVocabularyFilterName: ZIO[Any, AwsError, VocabularyFilterName] =
      AwsError.unwrapOptionField("vocabularyFilterName", vocabularyFilterName)
    def getLanguageModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("languageModelName", languageModelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.LanguageIdSettings
  ) extends zio.aws.transcribe.model.LanguageIdSettings.ReadOnly {
    override val vocabularyName: Optional[VocabularyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyName())
        .map(value => zio.aws.transcribe.model.primitives.VocabularyName(value))
    override val vocabularyFilterName: Optional[VocabularyFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyFilterName())
        .map(value =>
          zio.aws.transcribe.model.primitives.VocabularyFilterName(value)
        )
    override val languageModelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.languageModelName())
      .map(value => zio.aws.transcribe.model.primitives.ModelName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.LanguageIdSettings
  ): zio.aws.transcribe.model.LanguageIdSettings.ReadOnly = new Wrapper(impl)
}
