package zio.aws.transcribe.model
import scala.jdk.CollectionConverters.*
sealed trait LanguageCode {
  def unwrap: software.amazon.awssdk.services.transcribe.model.LanguageCode
}
object LanguageCode {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.LanguageCode
  ): zio.aws.transcribe.model.LanguageCode = value match {
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.AF_ZA =>
      val r = `af-ZA`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.AR_AE =>
      val r = `ar-AE`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.AR_SA =>
      val r = `ar-SA`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.DA_DK =>
      val r = `da-DK`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.DE_CH =>
      val r = `de-CH`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.DE_DE =>
      val r = `de-DE`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.EN_AB =>
      val r = `en-AB`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.EN_AU =>
      val r = `en-AU`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.EN_GB =>
      val r = `en-GB`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.EN_IE =>
      val r = `en-IE`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.EN_IN =>
      val r = `en-IN`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.EN_US =>
      val r = `en-US`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.EN_WL =>
      val r = `en-WL`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.ES_ES =>
      val r = `es-ES`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.ES_US =>
      val r = `es-US`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.FA_IR =>
      val r = `fa-IR`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.FR_CA =>
      val r = `fr-CA`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.FR_FR =>
      val r = `fr-FR`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.HE_IL =>
      val r = `he-IL`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.HI_IN =>
      val r = `hi-IN`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.ID_ID =>
      val r = `id-ID`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.IT_IT =>
      val r = `it-IT`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.JA_JP =>
      val r = `ja-JP`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.KO_KR =>
      val r = `ko-KR`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.MS_MY =>
      val r = `ms-MY`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.NL_NL =>
      val r = `nl-NL`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.PT_BR =>
      val r = `pt-BR`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.PT_PT =>
      val r = `pt-PT`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.RU_RU =>
      val r = `ru-RU`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.TA_IN =>
      val r = `ta-IN`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.TE_IN =>
      val r = `te-IN`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.TR_TR =>
      val r = `tr-TR`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.ZH_CN =>
      val r = `zh-CN`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.ZH_TW =>
      val r = `zh-TW`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.TH_TH =>
      val r = `th-TH`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.EN_ZA =>
      val r = `en-ZA`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.EN_NZ =>
      val r = `en-NZ`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.VI_VN =>
      val r = `vi-VN`
      r
    case software.amazon.awssdk.services.transcribe.model.LanguageCode.SV_SE =>
      val r = `sv-SE`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.UNKNOWN_TO_SDK_VERSION
  }
  case object `af-ZA` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.AF_ZA
  }
  case object `ar-AE` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.AR_AE
  }
  case object `ar-SA` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.AR_SA
  }
  case object `da-DK` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.DA_DK
  }
  case object `de-CH` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.DE_CH
  }
  case object `de-DE` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.DE_DE
  }
  case object `en-AB` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.EN_AB
  }
  case object `en-AU` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.EN_AU
  }
  case object `en-GB` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.EN_GB
  }
  case object `en-IE` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.EN_IE
  }
  case object `en-IN` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.EN_IN
  }
  case object `en-US` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.EN_US
  }
  case object `en-WL` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.EN_WL
  }
  case object `es-ES` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.ES_ES
  }
  case object `es-US` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.ES_US
  }
  case object `fa-IR` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.FA_IR
  }
  case object `fr-CA` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.FR_CA
  }
  case object `fr-FR` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.FR_FR
  }
  case object `he-IL` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.HE_IL
  }
  case object `hi-IN` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.HI_IN
  }
  case object `id-ID` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.ID_ID
  }
  case object `it-IT` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.IT_IT
  }
  case object `ja-JP` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.JA_JP
  }
  case object `ko-KR` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.KO_KR
  }
  case object `ms-MY` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.MS_MY
  }
  case object `nl-NL` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.NL_NL
  }
  case object `pt-BR` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.PT_BR
  }
  case object `pt-PT` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.PT_PT
  }
  case object `ru-RU` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.RU_RU
  }
  case object `ta-IN` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.TA_IN
  }
  case object `te-IN` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.TE_IN
  }
  case object `tr-TR` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.TR_TR
  }
  case object `zh-CN` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.ZH_CN
  }
  case object `zh-TW` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.ZH_TW
  }
  case object `th-TH` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.TH_TH
  }
  case object `en-ZA` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.EN_ZA
  }
  case object `en-NZ` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.EN_NZ
  }
  case object `vi-VN` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.VI_VN
  }
  case object `sv-SE` extends zio.aws.transcribe.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.LanguageCode =
      software.amazon.awssdk.services.transcribe.model.LanguageCode.SV_SE
  }
}
