package zio.aws.transcribe.model
import scala.jdk.CollectionConverters.*
sealed trait InputType {
  def unwrap: software.amazon.awssdk.services.transcribe.model.InputType
}
object InputType {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.InputType
  ): zio.aws.transcribe.model.InputType = value match {
    case software.amazon.awssdk.services.transcribe.model.InputType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.InputType.REAL_TIME =>
      val r = REAL_TIME
      r
    case software.amazon.awssdk.services.transcribe.model.InputType.POST_CALL =>
      val r = POST_CALL
      r
  }
  case object unknownToSdkVersion extends zio.aws.transcribe.model.InputType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.InputType =
      software.amazon.awssdk.services.transcribe.model.InputType.UNKNOWN_TO_SDK_VERSION
  }
  case object REAL_TIME extends zio.aws.transcribe.model.InputType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.InputType =
      software.amazon.awssdk.services.transcribe.model.InputType.REAL_TIME
  }
  case object POST_CALL extends zio.aws.transcribe.model.InputType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.InputType =
      software.amazon.awssdk.services.transcribe.model.InputType.POST_CALL
  }
}
