package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.TimestampMilliseconds
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AbsoluteTimeRange(
    startTime: Optional[TimestampMilliseconds] = Optional.Absent,
    endTime: Optional[TimestampMilliseconds] = Optional.Absent,
    first: Optional[TimestampMilliseconds] = Optional.Absent,
    last: Optional[TimestampMilliseconds] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.AbsoluteTimeRange = {
    import AbsoluteTimeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.AbsoluteTimeRange
      .builder()
      .optionallyWith(
        startTime.map(value =>
          TimestampMilliseconds.unwrap(value): java.lang.Long
        )
      )(_.startTime)
      .optionallyWith(
        endTime.map(value =>
          TimestampMilliseconds.unwrap(value): java.lang.Long
        )
      )(_.endTime)
      .optionallyWith(
        first.map(value => TimestampMilliseconds.unwrap(value): java.lang.Long)
      )(_.first)
      .optionallyWith(
        last.map(value => TimestampMilliseconds.unwrap(value): java.lang.Long)
      )(_.last)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly =
    zio.aws.transcribe.model.AbsoluteTimeRange.wrap(buildAwsValue())
}
object AbsoluteTimeRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.AbsoluteTimeRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.AbsoluteTimeRange =
      zio.aws.transcribe.model.AbsoluteTimeRange(
        startTime.map(value => value),
        endTime.map(value => value),
        first.map(value => value),
        last.map(value => value)
      )
    def startTime: Optional[TimestampMilliseconds]
    def endTime: Optional[TimestampMilliseconds]
    def first: Optional[TimestampMilliseconds]
    def last: Optional[TimestampMilliseconds]
    def getStartTime: ZIO[Any, AwsError, TimestampMilliseconds] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TimestampMilliseconds] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getFirst: ZIO[Any, AwsError, TimestampMilliseconds] =
      AwsError.unwrapOptionField("first", first)
    def getLast: ZIO[Any, AwsError, TimestampMilliseconds] =
      AwsError.unwrapOptionField("last", last)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.AbsoluteTimeRange
  ) extends zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly {
    override val startTime: Optional[TimestampMilliseconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startTime())
        .map(value =>
          zio.aws.transcribe.model.primitives.TimestampMilliseconds(value)
        )
    override val endTime: Optional[TimestampMilliseconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endTime())
        .map(value =>
          zio.aws.transcribe.model.primitives.TimestampMilliseconds(value)
        )
    override val first: Optional[TimestampMilliseconds] = zio.aws.core.internal
      .optionalFromNullable(impl.first())
      .map(value =>
        zio.aws.transcribe.model.primitives.TimestampMilliseconds(value)
      )
    override val last: Optional[TimestampMilliseconds] = zio.aws.core.internal
      .optionalFromNullable(impl.last())
      .map(value =>
        zio.aws.transcribe.model.primitives.TimestampMilliseconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.AbsoluteTimeRange
  ): zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly = new Wrapper(impl)
}
