package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.{Uri, VocabularyName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateMedicalVocabularyRequest(
    vocabularyName: VocabularyName,
    languageCode: zio.aws.transcribe.model.LanguageCode,
    vocabularyFileUri: Uri
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.UpdateMedicalVocabularyRequest = {
    import UpdateMedicalVocabularyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.UpdateMedicalVocabularyRequest
      .builder()
      .vocabularyName(VocabularyName.unwrap(vocabularyName): java.lang.String)
      .languageCode(languageCode.unwrap)
      .vocabularyFileUri(Uri.unwrap(vocabularyFileUri): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.UpdateMedicalVocabularyRequest.ReadOnly =
    zio.aws.transcribe.model.UpdateMedicalVocabularyRequest
      .wrap(buildAwsValue())
}
object UpdateMedicalVocabularyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.UpdateMedicalVocabularyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.UpdateMedicalVocabularyRequest =
      zio.aws.transcribe.model.UpdateMedicalVocabularyRequest(
        vocabularyName,
        languageCode,
        vocabularyFileUri
      )
    def vocabularyName: VocabularyName
    def languageCode: zio.aws.transcribe.model.LanguageCode
    def vocabularyFileUri: Uri
    def getVocabularyName: ZIO[Any, Nothing, VocabularyName] =
      ZIO.succeed(vocabularyName)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.transcribe.model.LanguageCode] =
      ZIO.succeed(languageCode)
    def getVocabularyFileUri: ZIO[Any, Nothing, Uri] =
      ZIO.succeed(vocabularyFileUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.UpdateMedicalVocabularyRequest
  ) extends zio.aws.transcribe.model.UpdateMedicalVocabularyRequest.ReadOnly {
    override val vocabularyName: VocabularyName =
      zio.aws.transcribe.model.primitives.VocabularyName(impl.vocabularyName())
    override val languageCode: zio.aws.transcribe.model.LanguageCode =
      zio.aws.transcribe.model.LanguageCode.wrap(impl.languageCode())
    override val vocabularyFileUri: Uri =
      zio.aws.transcribe.model.primitives.Uri(impl.vocabularyFileUri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.UpdateMedicalVocabularyRequest
  ): zio.aws.transcribe.model.UpdateMedicalVocabularyRequest.ReadOnly =
    new Wrapper(impl)
}
