package zio.aws.transcribe.model
import scala.jdk.CollectionConverters.*
sealed trait ParticipantRole {
  def unwrap: software.amazon.awssdk.services.transcribe.model.ParticipantRole
}
object ParticipantRole {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.ParticipantRole
  ): zio.aws.transcribe.model.ParticipantRole = value match {
    case software.amazon.awssdk.services.transcribe.model.ParticipantRole.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.ParticipantRole.AGENT =>
      val r = AGENT
      r
    case software.amazon.awssdk.services.transcribe.model.ParticipantRole.CUSTOMER =>
      val r = CUSTOMER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribe.model.ParticipantRole {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.ParticipantRole =
      software.amazon.awssdk.services.transcribe.model.ParticipantRole.UNKNOWN_TO_SDK_VERSION
  }
  case object AGENT extends zio.aws.transcribe.model.ParticipantRole {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.ParticipantRole =
      software.amazon.awssdk.services.transcribe.model.ParticipantRole.AGENT
  }
  case object CUSTOMER extends zio.aws.transcribe.model.ParticipantRole {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.ParticipantRole =
      software.amazon.awssdk.services.transcribe.model.ParticipantRole.CUSTOMER
  }
}
