package zio.aws.transcribe.model
import scala.jdk.CollectionConverters.*
sealed trait MedicalContentIdentificationType {
  def unwrap: software.amazon.awssdk.services.transcribe.model.MedicalContentIdentificationType
}
object MedicalContentIdentificationType {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.MedicalContentIdentificationType
  ): zio.aws.transcribe.model.MedicalContentIdentificationType = value match {
    case software.amazon.awssdk.services.transcribe.model.MedicalContentIdentificationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.MedicalContentIdentificationType.PHI =>
      val r = PHI
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribe.model.MedicalContentIdentificationType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.MedicalContentIdentificationType =
      software.amazon.awssdk.services.transcribe.model.MedicalContentIdentificationType.UNKNOWN_TO_SDK_VERSION
  }
  case object PHI
      extends zio.aws.transcribe.model.MedicalContentIdentificationType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.MedicalContentIdentificationType =
      software.amazon.awssdk.services.transcribe.model.MedicalContentIdentificationType.PHI
  }
}
