package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.TranscribeArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    resourceArn: Optional[TranscribeArn] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.transcribe.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        resourceArn.map(value => TranscribeArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.transcribe.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ListTagsForResourceResponse =
      zio.aws.transcribe.model.ListTagsForResourceResponse(
        resourceArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceArn: Optional[TranscribeArn]
    def tags: Optional[List[zio.aws.transcribe.model.Tag.ReadOnly]]
    def getResourceArn: ZIO[Any, AwsError, TranscribeArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListTagsForResourceResponse
  ) extends zio.aws.transcribe.model.ListTagsForResourceResponse.ReadOnly {
    override val resourceArn: Optional[TranscribeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.transcribe.model.primitives.TranscribeArn(value))
    override val tags: Optional[List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListTagsForResourceResponse
  ): zio.aws.transcribe.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
