package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.ModelName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteLanguageModelRequest(modelName: ModelName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.DeleteLanguageModelRequest = {
    import DeleteLanguageModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.DeleteLanguageModelRequest
      .builder()
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.DeleteLanguageModelRequest.ReadOnly =
    zio.aws.transcribe.model.DeleteLanguageModelRequest.wrap(buildAwsValue())
}
object DeleteLanguageModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.DeleteLanguageModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.DeleteLanguageModelRequest =
      zio.aws.transcribe.model.DeleteLanguageModelRequest(modelName)
    def modelName: ModelName
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.DeleteLanguageModelRequest
  ) extends zio.aws.transcribe.model.DeleteLanguageModelRequest.ReadOnly {
    override val modelName: ModelName =
      zio.aws.transcribe.model.primitives.ModelName(impl.modelName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.DeleteLanguageModelRequest
  ): zio.aws.transcribe.model.DeleteLanguageModelRequest.ReadOnly = new Wrapper(
    impl
  )
}
