package zio.aws.transcribe.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{DateTime, CategoryName}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CategoryProperties(
    categoryName: Optional[CategoryName] = Optional.Absent,
    rules: Optional[Iterable[zio.aws.transcribe.model.Rule]] = Optional.Absent,
    createTime: Optional[DateTime] = Optional.Absent,
    lastUpdateTime: Optional[DateTime] = Optional.Absent,
    inputType: Optional[zio.aws.transcribe.model.InputType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.CategoryProperties = {
    import CategoryProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.CategoryProperties
      .builder()
      .optionallyWith(
        categoryName.map(value => CategoryName.unwrap(value): java.lang.String)
      )(_.categoryName)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .optionallyWith(createTime.map(value => DateTime.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(
        lastUpdateTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .optionallyWith(inputType.map(value => value.unwrap))(_.inputType)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.CategoryProperties.ReadOnly =
    zio.aws.transcribe.model.CategoryProperties.wrap(buildAwsValue())
}
object CategoryProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.CategoryProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.CategoryProperties =
      zio.aws.transcribe.model.CategoryProperties(
        categoryName.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createTime.map(value => value),
        lastUpdateTime.map(value => value),
        inputType.map(value => value)
      )
    def categoryName: Optional[CategoryName]
    def rules: Optional[List[zio.aws.transcribe.model.Rule.ReadOnly]]
    def createTime: Optional[DateTime]
    def lastUpdateTime: Optional[DateTime]
    def inputType: Optional[zio.aws.transcribe.model.InputType]
    def getCategoryName: ZIO[Any, AwsError, CategoryName] =
      AwsError.unwrapOptionField("categoryName", categoryName)
    def getRules
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.Rule.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
    def getCreateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getLastUpdateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getInputType: ZIO[Any, AwsError, zio.aws.transcribe.model.InputType] =
      AwsError.unwrapOptionField("inputType", inputType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.CategoryProperties
  ) extends zio.aws.transcribe.model.CategoryProperties.ReadOnly {
    override val categoryName: Optional[CategoryName] = zio.aws.core.internal
      .optionalFromNullable(impl.categoryName())
      .map(value => zio.aws.transcribe.model.primitives.CategoryName(value))
    override val rules: Optional[List[zio.aws.transcribe.model.Rule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.Rule.wrap(item)
          }.toList
        )
    override val createTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val lastUpdateTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val inputType: Optional[zio.aws.transcribe.model.InputType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputType())
        .map(value => zio.aws.transcribe.model.InputType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.CategoryProperties
  ): zio.aws.transcribe.model.CategoryProperties.ReadOnly = new Wrapper(impl)
}
