package zio.aws.transcribe.model
import scala.jdk.CollectionConverters.*
sealed trait RedactionOutput {
  def unwrap: software.amazon.awssdk.services.transcribe.model.RedactionOutput
}
object RedactionOutput {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.RedactionOutput
  ): zio.aws.transcribe.model.RedactionOutput = value match {
    case software.amazon.awssdk.services.transcribe.model.RedactionOutput.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.RedactionOutput.REDACTED =>
      val r = redacted
      r
    case software.amazon.awssdk.services.transcribe.model.RedactionOutput.REDACTED_AND_UNREDACTED =>
      val r = redacted_and_unredacted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribe.model.RedactionOutput {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.RedactionOutput =
      software.amazon.awssdk.services.transcribe.model.RedactionOutput.UNKNOWN_TO_SDK_VERSION
  }
  case object redacted extends zio.aws.transcribe.model.RedactionOutput {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.RedactionOutput =
      software.amazon.awssdk.services.transcribe.model.RedactionOutput.REDACTED
  }
  case object redacted_and_unredacted
      extends zio.aws.transcribe.model.RedactionOutput {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.RedactionOutput =
      software.amazon.awssdk.services.transcribe.model.RedactionOutput.REDACTED_AND_UNREDACTED
  }
}
