package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Rule(
    nonTalkTimeFilter: Optional[zio.aws.transcribe.model.NonTalkTimeFilter] =
      Optional.Absent,
    interruptionFilter: Optional[zio.aws.transcribe.model.InterruptionFilter] =
      Optional.Absent,
    transcriptFilter: Optional[zio.aws.transcribe.model.TranscriptFilter] =
      Optional.Absent,
    sentimentFilter: Optional[zio.aws.transcribe.model.SentimentFilter] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.transcribe.model.Rule = {
    import Rule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.Rule
      .builder()
      .optionallyWith(nonTalkTimeFilter.map(value => value.buildAwsValue()))(
        _.nonTalkTimeFilter
      )
      .optionallyWith(interruptionFilter.map(value => value.buildAwsValue()))(
        _.interruptionFilter
      )
      .optionallyWith(transcriptFilter.map(value => value.buildAwsValue()))(
        _.transcriptFilter
      )
      .optionallyWith(sentimentFilter.map(value => value.buildAwsValue()))(
        _.sentimentFilter
      )
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.Rule.ReadOnly =
    zio.aws.transcribe.model.Rule.wrap(buildAwsValue())
}
object Rule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.transcribe.model.Rule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.Rule =
      zio.aws.transcribe.model.Rule(
        nonTalkTimeFilter.map(value => value.asEditable),
        interruptionFilter.map(value => value.asEditable),
        transcriptFilter.map(value => value.asEditable),
        sentimentFilter.map(value => value.asEditable)
      )
    def nonTalkTimeFilter
        : Optional[zio.aws.transcribe.model.NonTalkTimeFilter.ReadOnly]
    def interruptionFilter
        : Optional[zio.aws.transcribe.model.InterruptionFilter.ReadOnly]
    def transcriptFilter
        : Optional[zio.aws.transcribe.model.TranscriptFilter.ReadOnly]
    def sentimentFilter
        : Optional[zio.aws.transcribe.model.SentimentFilter.ReadOnly]
    def getNonTalkTimeFilter: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.NonTalkTimeFilter.ReadOnly
    ] = AwsError.unwrapOptionField("nonTalkTimeFilter", nonTalkTimeFilter)
    def getInterruptionFilter: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.InterruptionFilter.ReadOnly
    ] = AwsError.unwrapOptionField("interruptionFilter", interruptionFilter)
    def getTranscriptFilter: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.TranscriptFilter.ReadOnly
    ] = AwsError.unwrapOptionField("transcriptFilter", transcriptFilter)
    def getSentimentFilter: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.SentimentFilter.ReadOnly
    ] = AwsError.unwrapOptionField("sentimentFilter", sentimentFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.Rule
  ) extends zio.aws.transcribe.model.Rule.ReadOnly {
    override val nonTalkTimeFilter
        : Optional[zio.aws.transcribe.model.NonTalkTimeFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nonTalkTimeFilter())
        .map(value => zio.aws.transcribe.model.NonTalkTimeFilter.wrap(value))
    override val interruptionFilter
        : Optional[zio.aws.transcribe.model.InterruptionFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.interruptionFilter())
        .map(value => zio.aws.transcribe.model.InterruptionFilter.wrap(value))
    override val transcriptFilter
        : Optional[zio.aws.transcribe.model.TranscriptFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transcriptFilter())
        .map(value => zio.aws.transcribe.model.TranscriptFilter.wrap(value))
    override val sentimentFilter
        : Optional[zio.aws.transcribe.model.SentimentFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sentimentFilter())
        .map(value => zio.aws.transcribe.model.SentimentFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.Rule
  ): zio.aws.transcribe.model.Rule.ReadOnly = new Wrapper(impl)
}
