package zio.aws.transcribe.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{DateTime, VocabularyFilterName}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class VocabularyFilterInfo(
    vocabularyFilterName: Optional[VocabularyFilterName] = Optional.Absent,
    languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      Optional.Absent,
    lastModifiedTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.VocabularyFilterInfo = {
    import VocabularyFilterInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.VocabularyFilterInfo
      .builder()
      .optionallyWith(
        vocabularyFilterName.map(value =>
          VocabularyFilterName.unwrap(value): java.lang.String
        )
      )(_.vocabularyFilterName)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        lastModifiedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.VocabularyFilterInfo.ReadOnly =
    zio.aws.transcribe.model.VocabularyFilterInfo.wrap(buildAwsValue())
}
object VocabularyFilterInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.VocabularyFilterInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.VocabularyFilterInfo =
      zio.aws.transcribe.model.VocabularyFilterInfo(
        vocabularyFilterName.map(value => value),
        languageCode.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def vocabularyFilterName: Optional[VocabularyFilterName]
    def languageCode: Optional[zio.aws.transcribe.model.LanguageCode]
    def lastModifiedTime: Optional[DateTime]
    def getVocabularyFilterName: ZIO[Any, AwsError, VocabularyFilterName] =
      AwsError.unwrapOptionField("vocabularyFilterName", vocabularyFilterName)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getLastModifiedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.VocabularyFilterInfo
  ) extends zio.aws.transcribe.model.VocabularyFilterInfo.ReadOnly {
    override val vocabularyFilterName: Optional[VocabularyFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyFilterName())
        .map(value =>
          zio.aws.transcribe.model.primitives.VocabularyFilterName(value)
        )
    override val languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.transcribe.model.LanguageCode.wrap(value))
    override val lastModifiedTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.VocabularyFilterInfo
  ): zio.aws.transcribe.model.VocabularyFilterInfo.ReadOnly = new Wrapper(impl)
}
