package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.{Uri, Word, VocabularyFilterName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateVocabularyFilterRequest(
    vocabularyFilterName: VocabularyFilterName,
    words: Optional[Iterable[Word]] = Optional.Absent,
    vocabularyFilterFileUri: Optional[Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.UpdateVocabularyFilterRequest = {
    import UpdateVocabularyFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.UpdateVocabularyFilterRequest
      .builder()
      .vocabularyFilterName(
        VocabularyFilterName.unwrap(vocabularyFilterName): java.lang.String
      )
      .optionallyWith(
        words.map(value =>
          value.map { item =>
            Word.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.words)
      .optionallyWith(
        vocabularyFilterFileUri.map(value =>
          Uri.unwrap(value): java.lang.String
        )
      )(_.vocabularyFilterFileUri)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.UpdateVocabularyFilterRequest.ReadOnly =
    zio.aws.transcribe.model.UpdateVocabularyFilterRequest.wrap(buildAwsValue())
}
object UpdateVocabularyFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.UpdateVocabularyFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.UpdateVocabularyFilterRequest =
      zio.aws.transcribe.model.UpdateVocabularyFilterRequest(
        vocabularyFilterName,
        words.map(value => value),
        vocabularyFilterFileUri.map(value => value)
      )
    def vocabularyFilterName: VocabularyFilterName
    def words: Optional[List[Word]]
    def vocabularyFilterFileUri: Optional[Uri]
    def getVocabularyFilterName: ZIO[Any, Nothing, VocabularyFilterName] =
      ZIO.succeed(vocabularyFilterName)
    def getWords: ZIO[Any, AwsError, List[Word]] =
      AwsError.unwrapOptionField("words", words)
    def getVocabularyFilterFileUri: ZIO[Any, AwsError, Uri] = AwsError
      .unwrapOptionField("vocabularyFilterFileUri", vocabularyFilterFileUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.UpdateVocabularyFilterRequest
  ) extends zio.aws.transcribe.model.UpdateVocabularyFilterRequest.ReadOnly {
    override val vocabularyFilterName: VocabularyFilterName =
      zio.aws.transcribe.model.primitives
        .VocabularyFilterName(impl.vocabularyFilterName())
    override val words: Optional[List[Word]] = zio.aws.core.internal
      .optionalFromNullable(impl.words())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribe.model.primitives.Word(item)
        }.toList
      )
    override val vocabularyFilterFileUri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.vocabularyFilterFileUri())
      .map(value => zio.aws.transcribe.model.primitives.Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.UpdateVocabularyFilterRequest
  ): zio.aws.transcribe.model.UpdateVocabularyFilterRequest.ReadOnly =
    new Wrapper(impl)
}
