package zio.aws.transcribe.model
import scala.jdk.CollectionConverters.*
sealed trait MediaFormat {
  def unwrap: software.amazon.awssdk.services.transcribe.model.MediaFormat
}
object MediaFormat {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.MediaFormat
  ): zio.aws.transcribe.model.MediaFormat = value match {
    case software.amazon.awssdk.services.transcribe.model.MediaFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.MediaFormat.MP3 =>
      val r = mp3
      r
    case software.amazon.awssdk.services.transcribe.model.MediaFormat.MP4 =>
      val r = mp4
      r
    case software.amazon.awssdk.services.transcribe.model.MediaFormat.WAV =>
      val r = wav
      r
    case software.amazon.awssdk.services.transcribe.model.MediaFormat.FLAC =>
      val r = flac
      r
    case software.amazon.awssdk.services.transcribe.model.MediaFormat.OGG =>
      val r = ogg
      r
    case software.amazon.awssdk.services.transcribe.model.MediaFormat.AMR =>
      val r = amr
      r
    case software.amazon.awssdk.services.transcribe.model.MediaFormat.WEBM =>
      val r = webm
      r
  }
  case object unknownToSdkVersion extends zio.aws.transcribe.model.MediaFormat {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.MediaFormat =
      software.amazon.awssdk.services.transcribe.model.MediaFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object mp3 extends zio.aws.transcribe.model.MediaFormat {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.MediaFormat =
      software.amazon.awssdk.services.transcribe.model.MediaFormat.MP3
  }
  case object mp4 extends zio.aws.transcribe.model.MediaFormat {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.MediaFormat =
      software.amazon.awssdk.services.transcribe.model.MediaFormat.MP4
  }
  case object wav extends zio.aws.transcribe.model.MediaFormat {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.MediaFormat =
      software.amazon.awssdk.services.transcribe.model.MediaFormat.WAV
  }
  case object flac extends zio.aws.transcribe.model.MediaFormat {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.MediaFormat =
      software.amazon.awssdk.services.transcribe.model.MediaFormat.FLAC
  }
  case object ogg extends zio.aws.transcribe.model.MediaFormat {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.MediaFormat =
      software.amazon.awssdk.services.transcribe.model.MediaFormat.OGG
  }
  case object amr extends zio.aws.transcribe.model.MediaFormat {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.MediaFormat =
      software.amazon.awssdk.services.transcribe.model.MediaFormat.AMR
  }
  case object webm extends zio.aws.transcribe.model.MediaFormat {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.MediaFormat =
      software.amazon.awssdk.services.transcribe.model.MediaFormat.WEBM
  }
}
