package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.CategoryName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetCallAnalyticsCategoryRequest(categoryName: CategoryName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsCategoryRequest = {
    import GetCallAnalyticsCategoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsCategoryRequest
      .builder()
      .categoryName(CategoryName.unwrap(categoryName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.GetCallAnalyticsCategoryRequest.ReadOnly =
    zio.aws.transcribe.model.GetCallAnalyticsCategoryRequest
      .wrap(buildAwsValue())
}
object GetCallAnalyticsCategoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsCategoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.GetCallAnalyticsCategoryRequest =
      zio.aws.transcribe.model.GetCallAnalyticsCategoryRequest(categoryName)
    def categoryName: CategoryName
    def getCategoryName: ZIO[Any, Nothing, CategoryName] =
      ZIO.succeed(categoryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsCategoryRequest
  ) extends zio.aws.transcribe.model.GetCallAnalyticsCategoryRequest.ReadOnly {
    override val categoryName: CategoryName =
      zio.aws.transcribe.model.primitives.CategoryName(impl.categoryName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsCategoryRequest
  ): zio.aws.transcribe.model.GetCallAnalyticsCategoryRequest.ReadOnly =
    new Wrapper(impl)
}
