package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.{Uri, Phrase, VocabularyName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateVocabularyRequest(
    vocabularyName: VocabularyName,
    languageCode: zio.aws.transcribe.model.LanguageCode,
    phrases: Optional[Iterable[Phrase]] = Optional.Absent,
    vocabularyFileUri: Optional[Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.UpdateVocabularyRequest = {
    import UpdateVocabularyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.UpdateVocabularyRequest
      .builder()
      .vocabularyName(VocabularyName.unwrap(vocabularyName): java.lang.String)
      .languageCode(languageCode.unwrap)
      .optionallyWith(
        phrases.map(value =>
          value.map { item =>
            Phrase.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.phrases)
      .optionallyWith(
        vocabularyFileUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.vocabularyFileUri)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.UpdateVocabularyRequest.ReadOnly =
    zio.aws.transcribe.model.UpdateVocabularyRequest.wrap(buildAwsValue())
}
object UpdateVocabularyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.UpdateVocabularyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.UpdateVocabularyRequest =
      zio.aws.transcribe.model.UpdateVocabularyRequest(
        vocabularyName,
        languageCode,
        phrases.map(value => value),
        vocabularyFileUri.map(value => value)
      )
    def vocabularyName: VocabularyName
    def languageCode: zio.aws.transcribe.model.LanguageCode
    def phrases: Optional[List[Phrase]]
    def vocabularyFileUri: Optional[Uri]
    def getVocabularyName: ZIO[Any, Nothing, VocabularyName] =
      ZIO.succeed(vocabularyName)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.transcribe.model.LanguageCode] =
      ZIO.succeed(languageCode)
    def getPhrases: ZIO[Any, AwsError, List[Phrase]] =
      AwsError.unwrapOptionField("phrases", phrases)
    def getVocabularyFileUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("vocabularyFileUri", vocabularyFileUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.UpdateVocabularyRequest
  ) extends zio.aws.transcribe.model.UpdateVocabularyRequest.ReadOnly {
    override val vocabularyName: VocabularyName =
      zio.aws.transcribe.model.primitives.VocabularyName(impl.vocabularyName())
    override val languageCode: zio.aws.transcribe.model.LanguageCode =
      zio.aws.transcribe.model.LanguageCode.wrap(impl.languageCode())
    override val phrases: Optional[List[Phrase]] = zio.aws.core.internal
      .optionalFromNullable(impl.phrases())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribe.model.primitives.Phrase(item)
        }.toList
      )
    override val vocabularyFileUri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.vocabularyFileUri())
      .map(value => zio.aws.transcribe.model.primitives.Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.UpdateVocabularyRequest
  ): zio.aws.transcribe.model.UpdateVocabularyRequest.ReadOnly = new Wrapper(
    impl
  )
}
