package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.VocabularyFilterName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetVocabularyFilterRequest(
    vocabularyFilterName: VocabularyFilterName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.GetVocabularyFilterRequest = {
    import GetVocabularyFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.GetVocabularyFilterRequest
      .builder()
      .vocabularyFilterName(
        VocabularyFilterName.unwrap(vocabularyFilterName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.GetVocabularyFilterRequest.ReadOnly =
    zio.aws.transcribe.model.GetVocabularyFilterRequest.wrap(buildAwsValue())
}
object GetVocabularyFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.GetVocabularyFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.GetVocabularyFilterRequest =
      zio.aws.transcribe.model.GetVocabularyFilterRequest(vocabularyFilterName)
    def vocabularyFilterName: VocabularyFilterName
    def getVocabularyFilterName: ZIO[Any, Nothing, VocabularyFilterName] =
      ZIO.succeed(vocabularyFilterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.GetVocabularyFilterRequest
  ) extends zio.aws.transcribe.model.GetVocabularyFilterRequest.ReadOnly {
    override val vocabularyFilterName: VocabularyFilterName =
      zio.aws.transcribe.model.primitives
        .VocabularyFilterName(impl.vocabularyFilterName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.GetVocabularyFilterRequest
  ): zio.aws.transcribe.model.GetVocabularyFilterRequest.ReadOnly = new Wrapper(
    impl
  )
}
