package zio.aws.transcribe.model
import scala.jdk.CollectionConverters.*
sealed trait VocabularyState {
  def unwrap: software.amazon.awssdk.services.transcribe.model.VocabularyState
}
object VocabularyState {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.VocabularyState
  ): zio.aws.transcribe.model.VocabularyState = value match {
    case software.amazon.awssdk.services.transcribe.model.VocabularyState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.VocabularyState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.transcribe.model.VocabularyState.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.transcribe.model.VocabularyState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribe.model.VocabularyState {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.VocabularyState =
      software.amazon.awssdk.services.transcribe.model.VocabularyState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.transcribe.model.VocabularyState {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.VocabularyState =
      software.amazon.awssdk.services.transcribe.model.VocabularyState.PENDING
  }
  case object READY extends zio.aws.transcribe.model.VocabularyState {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.VocabularyState =
      software.amazon.awssdk.services.transcribe.model.VocabularyState.READY
  }
  case object FAILED extends zio.aws.transcribe.model.VocabularyState {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.VocabularyState =
      software.amazon.awssdk.services.transcribe.model.VocabularyState.FAILED
  }
}
