package zio.aws.transcribe
import zio.prelude.Subtype
import zio.aws.transcribe.model.primitives.{
  Word,
  Uri,
  Phrase,
  NonEmptyString,
  TagKey
}
import java.time.Instant
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object CallAnalyticsJobName extends Subtype[String]
    type CallAnalyticsJobName =
      zio.aws.transcribe.model.primitives.CallAnalyticsJobName.Type
    object CategoryName extends Subtype[String]
    type CategoryName = zio.aws.transcribe.model.primitives.CategoryName.Type
    object ChannelId extends Subtype[Int]
    type ChannelId = zio.aws.transcribe.model.primitives.ChannelId.Type
    object DataAccessRoleArn extends Subtype[String]
    type DataAccessRoleArn =
      zio.aws.transcribe.model.primitives.DataAccessRoleArn.Type
    object DateTime extends Subtype[Instant]
    type DateTime = zio.aws.transcribe.model.primitives.DateTime.Type
    object DurationInSeconds extends Subtype[Float]
    type DurationInSeconds =
      zio.aws.transcribe.model.primitives.DurationInSeconds.Type
    object FailureReason extends Subtype[String]
    type FailureReason = zio.aws.transcribe.model.primitives.FailureReason.Type
    object IdentifiedLanguageScore extends Subtype[Float]
    type IdentifiedLanguageScore =
      zio.aws.transcribe.model.primitives.IdentifiedLanguageScore.Type
    object KMSKeyId extends Subtype[String]
    type KMSKeyId = zio.aws.transcribe.model.primitives.KMSKeyId.Type
    object MaxAlternatives extends Subtype[Int]
    type MaxAlternatives =
      zio.aws.transcribe.model.primitives.MaxAlternatives.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.transcribe.model.primitives.MaxResults.Type
    object MaxSpeakers extends Subtype[Int]
    type MaxSpeakers = zio.aws.transcribe.model.primitives.MaxSpeakers.Type
    object MediaSampleRateHertz extends Subtype[Int]
    type MediaSampleRateHertz =
      zio.aws.transcribe.model.primitives.MediaSampleRateHertz.Type
    object MedicalMediaSampleRateHertz extends Subtype[Int]
    type MedicalMediaSampleRateHertz =
      zio.aws.transcribe.model.primitives.MedicalMediaSampleRateHertz.Type
    object ModelName extends Subtype[String]
    type ModelName = zio.aws.transcribe.model.primitives.ModelName.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.transcribe.model.primitives.NextToken.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString =
      zio.aws.transcribe.model.primitives.NonEmptyString.Type
    object OutputBucketName extends Subtype[String]
    type OutputBucketName =
      zio.aws.transcribe.model.primitives.OutputBucketName.Type
    object OutputKey extends Subtype[String]
    type OutputKey = zio.aws.transcribe.model.primitives.OutputKey.Type
    object Percentage extends Subtype[Int]
    type Percentage = zio.aws.transcribe.model.primitives.Percentage.Type
    object Phrase extends Subtype[String]
    type Phrase = zio.aws.transcribe.model.primitives.Phrase.Type
    object SubtitleOutputStartIndex extends Subtype[Int]
    type SubtitleOutputStartIndex =
      zio.aws.transcribe.model.primitives.SubtitleOutputStartIndex.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.transcribe.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.transcribe.model.primitives.TagValue.Type
    object TimestampMilliseconds extends Subtype[Long]
    type TimestampMilliseconds =
      zio.aws.transcribe.model.primitives.TimestampMilliseconds.Type
    object TranscribeArn extends Subtype[String]
    type TranscribeArn = zio.aws.transcribe.model.primitives.TranscribeArn.Type
    object TranscriptionJobName extends Subtype[String]
    type TranscriptionJobName =
      zio.aws.transcribe.model.primitives.TranscriptionJobName.Type
    object Uri extends Subtype[String]
    type Uri = zio.aws.transcribe.model.primitives.Uri.Type
    object VocabularyFilterName extends Subtype[String]
    type VocabularyFilterName =
      zio.aws.transcribe.model.primitives.VocabularyFilterName.Type
    object VocabularyName extends Subtype[String]
    type VocabularyName =
      zio.aws.transcribe.model.primitives.VocabularyName.Type
    object Word extends Subtype[String]
    type Word = zio.aws.transcribe.model.primitives.Word.Type
  }
  type CallAnalyticsJobSummaries =
    List[zio.aws.transcribe.model.CallAnalyticsJobSummary]
  type CategoryPropertiesList =
    List[zio.aws.transcribe.model.CategoryProperties]
  type ChannelDefinitions = List[zio.aws.transcribe.model.ChannelDefinition]
  type KMSEncryptionContextMap = Map[NonEmptyString, NonEmptyString]
  type LanguageCodeList = List[zio.aws.transcribe.model.LanguageCodeItem]
  type LanguageIdSettingsMap = Map[
    zio.aws.transcribe.model.LanguageCode,
    zio.aws.transcribe.model.LanguageIdSettings
  ]
  type LanguageOptions = List[zio.aws.transcribe.model.LanguageCode]
  type MedicalTranscriptionJobSummaries =
    List[zio.aws.transcribe.model.MedicalTranscriptionJobSummary]
  type Models = List[zio.aws.transcribe.model.LanguageModel]
  type Phrases = List[Phrase]
  type PiiEntityTypes = List[zio.aws.transcribe.model.PiiEntityType]
  type RuleList = List[zio.aws.transcribe.model.Rule]
  type SentimentValueList = List[zio.aws.transcribe.model.SentimentValue]
  type StringTargetList = List[NonEmptyString]
  type SubtitleFileUris = List[Uri]
  type SubtitleFormats = List[zio.aws.transcribe.model.SubtitleFormat]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.transcribe.model.Tag]
  type TranscriptionJobSummaries =
    List[zio.aws.transcribe.model.TranscriptionJobSummary]
  type Vocabularies = List[zio.aws.transcribe.model.VocabularyInfo]
  type VocabularyFilters = List[zio.aws.transcribe.model.VocabularyFilterInfo]
  type Words = List[Word]
}
