package zio.aws.transcribe.model
import scala.jdk.CollectionConverters.*
sealed trait VocabularyFilterMethod {
  def unwrap
      : software.amazon.awssdk.services.transcribe.model.VocabularyFilterMethod
}
object VocabularyFilterMethod {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.VocabularyFilterMethod
  ): zio.aws.transcribe.model.VocabularyFilterMethod = value match {
    case software.amazon.awssdk.services.transcribe.model.VocabularyFilterMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.VocabularyFilterMethod.REMOVE =>
      val r = remove
      r
    case software.amazon.awssdk.services.transcribe.model.VocabularyFilterMethod.MASK =>
      val r = mask
      r
    case software.amazon.awssdk.services.transcribe.model.VocabularyFilterMethod.TAG =>
      val r = tag
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribe.model.VocabularyFilterMethod {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.VocabularyFilterMethod =
      software.amazon.awssdk.services.transcribe.model.VocabularyFilterMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object remove extends zio.aws.transcribe.model.VocabularyFilterMethod {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.VocabularyFilterMethod =
      software.amazon.awssdk.services.transcribe.model.VocabularyFilterMethod.REMOVE
  }
  case object mask extends zio.aws.transcribe.model.VocabularyFilterMethod {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.VocabularyFilterMethod =
      software.amazon.awssdk.services.transcribe.model.VocabularyFilterMethod.MASK
  }
  case object tag extends zio.aws.transcribe.model.VocabularyFilterMethod {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.VocabularyFilterMethod =
      software.amazon.awssdk.services.transcribe.model.VocabularyFilterMethod.TAG
  }
}
