package zio.aws.transcribe.model
import scala.jdk.CollectionConverters.*
sealed trait Type {
  def unwrap: software.amazon.awssdk.services.transcribe.model.Type
}
object Type {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.Type
  ): zio.aws.transcribe.model.Type = value match {
    case software.amazon.awssdk.services.transcribe.model.Type.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.Type.CONVERSATION =>
      val r = CONVERSATION
      r
    case software.amazon.awssdk.services.transcribe.model.Type.DICTATION =>
      val r = DICTATION
      r
  }
  case object unknownToSdkVersion extends zio.aws.transcribe.model.Type {
    override def unwrap: software.amazon.awssdk.services.transcribe.model.Type =
      software.amazon.awssdk.services.transcribe.model.Type.UNKNOWN_TO_SDK_VERSION
  }
  case object CONVERSATION extends zio.aws.transcribe.model.Type {
    override def unwrap: software.amazon.awssdk.services.transcribe.model.Type =
      software.amazon.awssdk.services.transcribe.model.Type.CONVERSATION
  }
  case object DICTATION extends zio.aws.transcribe.model.Type {
    override def unwrap: software.amazon.awssdk.services.transcribe.model.Type =
      software.amazon.awssdk.services.transcribe.model.Type.DICTATION
  }
}
