package zio.aws.transcribe.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{SubtitleOutputStartIndex, Uri}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SubtitlesOutput(
    formats: Optional[Iterable[zio.aws.transcribe.model.SubtitleFormat]] =
      Optional.Absent,
    subtitleFileUris: Optional[Iterable[Uri]] = Optional.Absent,
    outputStartIndex: Optional[SubtitleOutputStartIndex] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.SubtitlesOutput = {
    import SubtitlesOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.SubtitlesOutput
      .builder()
      .optionallyWith(
        formats.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.formatsWithStrings)
      .optionallyWith(
        subtitleFileUris.map(value =>
          value.map { item =>
            Uri.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subtitleFileUris)
      .optionallyWith(
        outputStartIndex.map(value =>
          SubtitleOutputStartIndex.unwrap(value): Integer
        )
      )(_.outputStartIndex)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.SubtitlesOutput.ReadOnly =
    zio.aws.transcribe.model.SubtitlesOutput.wrap(buildAwsValue())
}
object SubtitlesOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.SubtitlesOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.SubtitlesOutput =
      zio.aws.transcribe.model.SubtitlesOutput(
        formats.map(value => value),
        subtitleFileUris.map(value => value),
        outputStartIndex.map(value => value)
      )
    def formats: Optional[List[zio.aws.transcribe.model.SubtitleFormat]]
    def subtitleFileUris: Optional[List[Uri]]
    def outputStartIndex: Optional[SubtitleOutputStartIndex]
    def getFormats
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.SubtitleFormat]] =
      AwsError.unwrapOptionField("formats", formats)
    def getSubtitleFileUris: ZIO[Any, AwsError, List[Uri]] =
      AwsError.unwrapOptionField("subtitleFileUris", subtitleFileUris)
    def getOutputStartIndex: ZIO[Any, AwsError, SubtitleOutputStartIndex] =
      AwsError.unwrapOptionField("outputStartIndex", outputStartIndex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.SubtitlesOutput
  ) extends zio.aws.transcribe.model.SubtitlesOutput.ReadOnly {
    override val formats
        : Optional[List[zio.aws.transcribe.model.SubtitleFormat]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formats())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.SubtitleFormat.wrap(item)
          }.toList
        )
    override val subtitleFileUris: Optional[List[Uri]] = zio.aws.core.internal
      .optionalFromNullable(impl.subtitleFileUris())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribe.model.primitives.Uri(item)
        }.toList
      )
    override val outputStartIndex: Optional[SubtitleOutputStartIndex] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputStartIndex())
        .map(value =>
          zio.aws.transcribe.model.primitives.SubtitleOutputStartIndex(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.SubtitlesOutput
  ): zio.aws.transcribe.model.SubtitlesOutput.ReadOnly = new Wrapper(impl)
}
