package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.TranscriptionJobName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteMedicalTranscriptionJobRequest(
    medicalTranscriptionJobName: TranscriptionJobName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.DeleteMedicalTranscriptionJobRequest = {
    import DeleteMedicalTranscriptionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.DeleteMedicalTranscriptionJobRequest
      .builder()
      .medicalTranscriptionJobName(
        TranscriptionJobName.unwrap(
          medicalTranscriptionJobName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.DeleteMedicalTranscriptionJobRequest.ReadOnly =
    zio.aws.transcribe.model.DeleteMedicalTranscriptionJobRequest
      .wrap(buildAwsValue())
}
object DeleteMedicalTranscriptionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.DeleteMedicalTranscriptionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.transcribe.model.DeleteMedicalTranscriptionJobRequest =
      zio.aws.transcribe.model
        .DeleteMedicalTranscriptionJobRequest(medicalTranscriptionJobName)
    def medicalTranscriptionJobName: TranscriptionJobName
    def getMedicalTranscriptionJobName
        : ZIO[Any, Nothing, TranscriptionJobName] =
      ZIO.succeed(medicalTranscriptionJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.DeleteMedicalTranscriptionJobRequest
  ) extends zio.aws.transcribe.model.DeleteMedicalTranscriptionJobRequest.ReadOnly {
    override val medicalTranscriptionJobName: TranscriptionJobName =
      zio.aws.transcribe.model.primitives
        .TranscriptionJobName(impl.medicalTranscriptionJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.DeleteMedicalTranscriptionJobRequest
  ): zio.aws.transcribe.model.DeleteMedicalTranscriptionJobRequest.ReadOnly =
    new Wrapper(impl)
}
