package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetTranscriptionJobResponse(
    transcriptionJob: Optional[zio.aws.transcribe.model.TranscriptionJob] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobResponse = {
    import GetTranscriptionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobResponse
      .builder()
      .optionallyWith(transcriptionJob.map(value => value.buildAwsValue()))(
        _.transcriptionJob
      )
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.GetTranscriptionJobResponse.ReadOnly =
    zio.aws.transcribe.model.GetTranscriptionJobResponse.wrap(buildAwsValue())
}
object GetTranscriptionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.GetTranscriptionJobResponse =
      zio.aws.transcribe.model.GetTranscriptionJobResponse(
        transcriptionJob.map(value => value.asEditable)
      )
    def transcriptionJob
        : Optional[zio.aws.transcribe.model.TranscriptionJob.ReadOnly]
    def getTranscriptionJob: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.TranscriptionJob.ReadOnly
    ] = AwsError.unwrapOptionField("transcriptionJob", transcriptionJob)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobResponse
  ) extends zio.aws.transcribe.model.GetTranscriptionJobResponse.ReadOnly {
    override val transcriptionJob
        : Optional[zio.aws.transcribe.model.TranscriptionJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transcriptionJob())
        .map(value => zio.aws.transcribe.model.TranscriptionJob.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobResponse
  ): zio.aws.transcribe.model.GetTranscriptionJobResponse.ReadOnly =
    new Wrapper(impl)
}
