package zio.aws.transcribe.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{
  IdentifiedLanguageScore,
  FailureReason,
  MediaSampleRateHertz,
  DateTime,
  TranscriptionJobName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class TranscriptionJob(
    transcriptionJobName: Optional[TranscriptionJobName] = Optional.Absent,
    transcriptionJobStatus: Optional[
      zio.aws.transcribe.model.TranscriptionJobStatus
    ] = Optional.Absent,
    languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      Optional.Absent,
    mediaSampleRateHertz: Optional[MediaSampleRateHertz] = Optional.Absent,
    mediaFormat: Optional[zio.aws.transcribe.model.MediaFormat] =
      Optional.Absent,
    media: Optional[zio.aws.transcribe.model.Media] = Optional.Absent,
    transcript: Optional[zio.aws.transcribe.model.Transcript] = Optional.Absent,
    startTime: Optional[DateTime] = Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    completionTime: Optional[DateTime] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    settings: Optional[zio.aws.transcribe.model.Settings] = Optional.Absent,
    modelSettings: Optional[zio.aws.transcribe.model.ModelSettings] =
      Optional.Absent,
    jobExecutionSettings: Optional[
      zio.aws.transcribe.model.JobExecutionSettings
    ] = Optional.Absent,
    contentRedaction: Optional[zio.aws.transcribe.model.ContentRedaction] =
      Optional.Absent,
    identifyLanguage: Optional[Boolean] = Optional.Absent,
    languageOptions: Optional[Iterable[zio.aws.transcribe.model.LanguageCode]] =
      Optional.Absent,
    identifiedLanguageScore: Optional[IdentifiedLanguageScore] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.transcribe.model.Tag]] = Optional.Absent,
    subtitles: Optional[zio.aws.transcribe.model.SubtitlesOutput] =
      Optional.Absent,
    languageIdSettings: Optional[Map[
      zio.aws.transcribe.model.LanguageCode,
      zio.aws.transcribe.model.LanguageIdSettings
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.TranscriptionJob = {
    import TranscriptionJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.TranscriptionJob
      .builder()
      .optionallyWith(
        transcriptionJobName.map(value =>
          TranscriptionJobName.unwrap(value): java.lang.String
        )
      )(_.transcriptionJobName)
      .optionallyWith(transcriptionJobStatus.map(value => value.unwrap))(
        _.transcriptionJobStatus
      )
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        mediaSampleRateHertz.map(value =>
          MediaSampleRateHertz.unwrap(value): Integer
        )
      )(_.mediaSampleRateHertz)
      .optionallyWith(mediaFormat.map(value => value.unwrap))(_.mediaFormat)
      .optionallyWith(media.map(value => value.buildAwsValue()))(_.media)
      .optionallyWith(transcript.map(value => value.buildAwsValue()))(
        _.transcript
      )
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        completionTime.map(value => DateTime.unwrap(value): Instant)
      )(_.completionTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .optionallyWith(modelSettings.map(value => value.buildAwsValue()))(
        _.modelSettings
      )
      .optionallyWith(jobExecutionSettings.map(value => value.buildAwsValue()))(
        _.jobExecutionSettings
      )
      .optionallyWith(contentRedaction.map(value => value.buildAwsValue()))(
        _.contentRedaction
      )
      .optionallyWith(identifyLanguage.map(value => value: java.lang.Boolean))(
        _.identifyLanguage
      )
      .optionallyWith(
        languageOptions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.languageOptionsWithStrings)
      .optionallyWith(
        identifiedLanguageScore.map(value =>
          IdentifiedLanguageScore.unwrap(value): java.lang.Float
        )
      )(_.identifiedLanguageScore)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(subtitles.map(value => value.buildAwsValue()))(
        _.subtitles
      )
      .optionallyWith(
        languageIdSettings.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.languageIdSettingsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.TranscriptionJob.ReadOnly =
    zio.aws.transcribe.model.TranscriptionJob.wrap(buildAwsValue())
}
object TranscriptionJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.TranscriptionJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.TranscriptionJob =
      zio.aws.transcribe.model.TranscriptionJob(
        transcriptionJobName.map(value => value),
        transcriptionJobStatus.map(value => value),
        languageCode.map(value => value),
        mediaSampleRateHertz.map(value => value),
        mediaFormat.map(value => value),
        media.map(value => value.asEditable),
        transcript.map(value => value.asEditable),
        startTime.map(value => value),
        creationTime.map(value => value),
        completionTime.map(value => value),
        failureReason.map(value => value),
        settings.map(value => value.asEditable),
        modelSettings.map(value => value.asEditable),
        jobExecutionSettings.map(value => value.asEditable),
        contentRedaction.map(value => value.asEditable),
        identifyLanguage.map(value => value),
        languageOptions.map(value => value),
        identifiedLanguageScore.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        subtitles.map(value => value.asEditable),
        languageIdSettings.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def transcriptionJobName: Optional[TranscriptionJobName]
    def transcriptionJobStatus
        : Optional[zio.aws.transcribe.model.TranscriptionJobStatus]
    def languageCode: Optional[zio.aws.transcribe.model.LanguageCode]
    def mediaSampleRateHertz: Optional[MediaSampleRateHertz]
    def mediaFormat: Optional[zio.aws.transcribe.model.MediaFormat]
    def media: Optional[zio.aws.transcribe.model.Media.ReadOnly]
    def transcript: Optional[zio.aws.transcribe.model.Transcript.ReadOnly]
    def startTime: Optional[DateTime]
    def creationTime: Optional[DateTime]
    def completionTime: Optional[DateTime]
    def failureReason: Optional[FailureReason]
    def settings: Optional[zio.aws.transcribe.model.Settings.ReadOnly]
    def modelSettings: Optional[zio.aws.transcribe.model.ModelSettings.ReadOnly]
    def jobExecutionSettings
        : Optional[zio.aws.transcribe.model.JobExecutionSettings.ReadOnly]
    def contentRedaction
        : Optional[zio.aws.transcribe.model.ContentRedaction.ReadOnly]
    def identifyLanguage: Optional[Boolean]
    def languageOptions: Optional[List[zio.aws.transcribe.model.LanguageCode]]
    def identifiedLanguageScore: Optional[IdentifiedLanguageScore]
    def tags: Optional[List[zio.aws.transcribe.model.Tag.ReadOnly]]
    def subtitles: Optional[zio.aws.transcribe.model.SubtitlesOutput.ReadOnly]
    def languageIdSettings: Optional[Map[
      zio.aws.transcribe.model.LanguageCode,
      zio.aws.transcribe.model.LanguageIdSettings.ReadOnly
    ]]
    def getTranscriptionJobName: ZIO[Any, AwsError, TranscriptionJobName] =
      AwsError.unwrapOptionField("transcriptionJobName", transcriptionJobName)
    def getTranscriptionJobStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.TranscriptionJobStatus] =
      AwsError.unwrapOptionField(
        "transcriptionJobStatus",
        transcriptionJobStatus
      )
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getMediaSampleRateHertz: ZIO[Any, AwsError, MediaSampleRateHertz] =
      AwsError.unwrapOptionField("mediaSampleRateHertz", mediaSampleRateHertz)
    def getMediaFormat
        : ZIO[Any, AwsError, zio.aws.transcribe.model.MediaFormat] =
      AwsError.unwrapOptionField("mediaFormat", mediaFormat)
    def getMedia: ZIO[Any, AwsError, zio.aws.transcribe.model.Media.ReadOnly] =
      AwsError.unwrapOptionField("media", media)
    def getTranscript
        : ZIO[Any, AwsError, zio.aws.transcribe.model.Transcript.ReadOnly] =
      AwsError.unwrapOptionField("transcript", transcript)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCompletionTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getSettings
        : ZIO[Any, AwsError, zio.aws.transcribe.model.Settings.ReadOnly] =
      AwsError.unwrapOptionField("settings", settings)
    def getModelSettings
        : ZIO[Any, AwsError, zio.aws.transcribe.model.ModelSettings.ReadOnly] =
      AwsError.unwrapOptionField("modelSettings", modelSettings)
    def getJobExecutionSettings: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.JobExecutionSettings.ReadOnly
    ] = AwsError.unwrapOptionField("jobExecutionSettings", jobExecutionSettings)
    def getContentRedaction: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.ContentRedaction.ReadOnly
    ] = AwsError.unwrapOptionField("contentRedaction", contentRedaction)
    def getIdentifyLanguage: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("identifyLanguage", identifyLanguage)
    def getLanguageOptions
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.LanguageCode]] =
      AwsError.unwrapOptionField("languageOptions", languageOptions)
    def getIdentifiedLanguageScore
        : ZIO[Any, AwsError, IdentifiedLanguageScore] = AwsError
      .unwrapOptionField("identifiedLanguageScore", identifiedLanguageScore)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSubtitles: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.SubtitlesOutput.ReadOnly
    ] = AwsError.unwrapOptionField("subtitles", subtitles)
    def getLanguageIdSettings: ZIO[Any, AwsError, Map[
      zio.aws.transcribe.model.LanguageCode,
      zio.aws.transcribe.model.LanguageIdSettings.ReadOnly
    ]] = AwsError.unwrapOptionField("languageIdSettings", languageIdSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.TranscriptionJob
  ) extends zio.aws.transcribe.model.TranscriptionJob.ReadOnly {
    override val transcriptionJobName: Optional[TranscriptionJobName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transcriptionJobName())
        .map(value =>
          zio.aws.transcribe.model.primitives.TranscriptionJobName(value)
        )
    override val transcriptionJobStatus
        : Optional[zio.aws.transcribe.model.TranscriptionJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transcriptionJobStatus())
        .map(value =>
          zio.aws.transcribe.model.TranscriptionJobStatus.wrap(value)
        )
    override val languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.transcribe.model.LanguageCode.wrap(value))
    override val mediaSampleRateHertz: Optional[MediaSampleRateHertz] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaSampleRateHertz())
        .map(value =>
          zio.aws.transcribe.model.primitives.MediaSampleRateHertz(value)
        )
    override val mediaFormat: Optional[zio.aws.transcribe.model.MediaFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaFormat())
        .map(value => zio.aws.transcribe.model.MediaFormat.wrap(value))
    override val media: Optional[zio.aws.transcribe.model.Media.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.media())
        .map(value => zio.aws.transcribe.model.Media.wrap(value))
    override val transcript
        : Optional[zio.aws.transcribe.model.Transcript.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transcript())
        .map(value => zio.aws.transcribe.model.Transcript.wrap(value))
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val completionTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.completionTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.transcribe.model.primitives.FailureReason(value))
    override val settings
        : Optional[zio.aws.transcribe.model.Settings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.settings())
        .map(value => zio.aws.transcribe.model.Settings.wrap(value))
    override val modelSettings
        : Optional[zio.aws.transcribe.model.ModelSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelSettings())
        .map(value => zio.aws.transcribe.model.ModelSettings.wrap(value))
    override val jobExecutionSettings
        : Optional[zio.aws.transcribe.model.JobExecutionSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobExecutionSettings())
        .map(value => zio.aws.transcribe.model.JobExecutionSettings.wrap(value))
    override val contentRedaction
        : Optional[zio.aws.transcribe.model.ContentRedaction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentRedaction())
        .map(value => zio.aws.transcribe.model.ContentRedaction.wrap(value))
    override val identifyLanguage: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.identifyLanguage())
      .map(value => value: Boolean)
    override val languageOptions
        : Optional[List[zio.aws.transcribe.model.LanguageCode]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.LanguageCode.wrap(item)
          }.toList
        )
    override val identifiedLanguageScore: Optional[IdentifiedLanguageScore] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identifiedLanguageScore())
        .map(value =>
          zio.aws.transcribe.model.primitives.IdentifiedLanguageScore(value)
        )
    override val tags: Optional[List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.Tag.wrap(item)
          }.toList
        )
    override val subtitles
        : Optional[zio.aws.transcribe.model.SubtitlesOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subtitles())
        .map(value => zio.aws.transcribe.model.SubtitlesOutput.wrap(value))
    override val languageIdSettings: Optional[Map[
      zio.aws.transcribe.model.LanguageCode,
      zio.aws.transcribe.model.LanguageIdSettings.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.languageIdSettings())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.transcribe.model.LanguageCode.wrap(
              key
            ) -> zio.aws.transcribe.model.LanguageIdSettings.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.TranscriptionJob
  ): zio.aws.transcribe.model.TranscriptionJob.ReadOnly = new Wrapper(impl)
}
