package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartTranscriptionJobResponse(
    transcriptionJob: Optional[zio.aws.transcribe.model.TranscriptionJob] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobResponse = {
    import StartTranscriptionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobResponse
      .builder()
      .optionallyWith(transcriptionJob.map(value => value.buildAwsValue()))(
        _.transcriptionJob
      )
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.StartTranscriptionJobResponse.ReadOnly =
    zio.aws.transcribe.model.StartTranscriptionJobResponse.wrap(buildAwsValue())
}
object StartTranscriptionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.StartTranscriptionJobResponse =
      zio.aws.transcribe.model.StartTranscriptionJobResponse(
        transcriptionJob.map(value => value.asEditable)
      )
    def transcriptionJob
        : Optional[zio.aws.transcribe.model.TranscriptionJob.ReadOnly]
    def getTranscriptionJob: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.TranscriptionJob.ReadOnly
    ] = AwsError.unwrapOptionField("transcriptionJob", transcriptionJob)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobResponse
  ) extends zio.aws.transcribe.model.StartTranscriptionJobResponse.ReadOnly {
    override val transcriptionJob
        : Optional[zio.aws.transcribe.model.TranscriptionJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transcriptionJob())
        .map(value => zio.aws.transcribe.model.TranscriptionJob.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobResponse
  ): zio.aws.transcribe.model.StartTranscriptionJobResponse.ReadOnly =
    new Wrapper(impl)
}
