package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.CallAnalyticsJobName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteCallAnalyticsJobRequest(
    callAnalyticsJobName: CallAnalyticsJobName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsJobRequest = {
    import DeleteCallAnalyticsJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsJobRequest
      .builder()
      .callAnalyticsJobName(
        CallAnalyticsJobName.unwrap(callAnalyticsJobName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.DeleteCallAnalyticsJobRequest.ReadOnly =
    zio.aws.transcribe.model.DeleteCallAnalyticsJobRequest.wrap(buildAwsValue())
}
object DeleteCallAnalyticsJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.DeleteCallAnalyticsJobRequest =
      zio.aws.transcribe.model
        .DeleteCallAnalyticsJobRequest(callAnalyticsJobName)
    def callAnalyticsJobName: CallAnalyticsJobName
    def getCallAnalyticsJobName: ZIO[Any, Nothing, CallAnalyticsJobName] =
      ZIO.succeed(callAnalyticsJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsJobRequest
  ) extends zio.aws.transcribe.model.DeleteCallAnalyticsJobRequest.ReadOnly {
    override val callAnalyticsJobName: CallAnalyticsJobName =
      zio.aws.transcribe.model.primitives
        .CallAnalyticsJobName(impl.callAnalyticsJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsJobRequest
  ): zio.aws.transcribe.model.DeleteCallAnalyticsJobRequest.ReadOnly =
    new Wrapper(impl)
}
