package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.CategoryName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateCallAnalyticsCategoryRequest(
    categoryName: CategoryName,
    rules: Iterable[zio.aws.transcribe.model.Rule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryRequest = {
    import CreateCallAnalyticsCategoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryRequest
      .builder()
      .categoryName(CategoryName.unwrap(categoryName): java.lang.String)
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.CreateCallAnalyticsCategoryRequest.ReadOnly =
    zio.aws.transcribe.model.CreateCallAnalyticsCategoryRequest
      .wrap(buildAwsValue())
}
object CreateCallAnalyticsCategoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.transcribe.model.CreateCallAnalyticsCategoryRequest =
      zio.aws.transcribe.model.CreateCallAnalyticsCategoryRequest(
        categoryName,
        rules.map { item =>
          item.asEditable
        }
      )
    def categoryName: CategoryName
    def rules: List[zio.aws.transcribe.model.Rule.ReadOnly]
    def getCategoryName: ZIO[Any, Nothing, CategoryName] =
      ZIO.succeed(categoryName)
    def getRules
        : ZIO[Any, Nothing, List[zio.aws.transcribe.model.Rule.ReadOnly]] =
      ZIO.succeed(rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryRequest
  ) extends zio.aws.transcribe.model.CreateCallAnalyticsCategoryRequest.ReadOnly {
    override val categoryName: CategoryName =
      zio.aws.transcribe.model.primitives.CategoryName(impl.categoryName())
    override val rules: List[zio.aws.transcribe.model.Rule.ReadOnly] = impl
      .rules()
      .asScala
      .map { item =>
        zio.aws.transcribe.model.Rule.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryRequest
  ): zio.aws.transcribe.model.CreateCallAnalyticsCategoryRequest.ReadOnly =
    new Wrapper(impl)
}
