package zio.aws.transcribe.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{
  FailureReason,
  DateTime,
  TranscriptionJobName
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class MedicalTranscriptionJobSummary(
    medicalTranscriptionJobName: Optional[TranscriptionJobName] =
      Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    startTime: Optional[DateTime] = Optional.Absent,
    completionTime: Optional[DateTime] = Optional.Absent,
    languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      Optional.Absent,
    transcriptionJobStatus: Optional[
      zio.aws.transcribe.model.TranscriptionJobStatus
    ] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    outputLocationType: Optional[zio.aws.transcribe.model.OutputLocationType] =
      Optional.Absent,
    specialty: Optional[zio.aws.transcribe.model.Specialty] = Optional.Absent,
    contentIdentificationType: Optional[
      zio.aws.transcribe.model.MedicalContentIdentificationType
    ] = Optional.Absent,
    `type`: Optional[zio.aws.transcribe.model.Type] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJobSummary = {
    import MedicalTranscriptionJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJobSummary
      .builder()
      .optionallyWith(
        medicalTranscriptionJobName.map(value =>
          TranscriptionJobName.unwrap(value): java.lang.String
        )
      )(_.medicalTranscriptionJobName)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        completionTime.map(value => DateTime.unwrap(value): Instant)
      )(_.completionTime)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(transcriptionJobStatus.map(value => value.unwrap))(
        _.transcriptionJobStatus
      )
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(outputLocationType.map(value => value.unwrap))(
        _.outputLocationType
      )
      .optionallyWith(specialty.map(value => value.unwrap))(_.specialty)
      .optionallyWith(contentIdentificationType.map(value => value.unwrap))(
        _.contentIdentificationType
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.MedicalTranscriptionJobSummary.ReadOnly =
    zio.aws.transcribe.model.MedicalTranscriptionJobSummary
      .wrap(buildAwsValue())
}
object MedicalTranscriptionJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.MedicalTranscriptionJobSummary =
      zio.aws.transcribe.model.MedicalTranscriptionJobSummary(
        medicalTranscriptionJobName.map(value => value),
        creationTime.map(value => value),
        startTime.map(value => value),
        completionTime.map(value => value),
        languageCode.map(value => value),
        transcriptionJobStatus.map(value => value),
        failureReason.map(value => value),
        outputLocationType.map(value => value),
        specialty.map(value => value),
        contentIdentificationType.map(value => value),
        `type`.map(value => value)
      )
    def medicalTranscriptionJobName: Optional[TranscriptionJobName]
    def creationTime: Optional[DateTime]
    def startTime: Optional[DateTime]
    def completionTime: Optional[DateTime]
    def languageCode: Optional[zio.aws.transcribe.model.LanguageCode]
    def transcriptionJobStatus
        : Optional[zio.aws.transcribe.model.TranscriptionJobStatus]
    def failureReason: Optional[FailureReason]
    def outputLocationType
        : Optional[zio.aws.transcribe.model.OutputLocationType]
    def specialty: Optional[zio.aws.transcribe.model.Specialty]
    def contentIdentificationType
        : Optional[zio.aws.transcribe.model.MedicalContentIdentificationType]
    def `type`: Optional[zio.aws.transcribe.model.Type]
    def getMedicalTranscriptionJobName
        : ZIO[Any, AwsError, TranscriptionJobName] = AwsError.unwrapOptionField(
      "medicalTranscriptionJobName",
      medicalTranscriptionJobName
    )
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getCompletionTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getTranscriptionJobStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.TranscriptionJobStatus] =
      AwsError.unwrapOptionField(
        "transcriptionJobStatus",
        transcriptionJobStatus
      )
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getOutputLocationType
        : ZIO[Any, AwsError, zio.aws.transcribe.model.OutputLocationType] =
      AwsError.unwrapOptionField("outputLocationType", outputLocationType)
    def getSpecialty: ZIO[Any, AwsError, zio.aws.transcribe.model.Specialty] =
      AwsError.unwrapOptionField("specialty", specialty)
    def getContentIdentificationType: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.MedicalContentIdentificationType
    ] = AwsError.unwrapOptionField(
      "contentIdentificationType",
      contentIdentificationType
    )
    def getType: ZIO[Any, AwsError, zio.aws.transcribe.model.Type] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJobSummary
  ) extends zio.aws.transcribe.model.MedicalTranscriptionJobSummary.ReadOnly {
    override val medicalTranscriptionJobName: Optional[TranscriptionJobName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.medicalTranscriptionJobName())
        .map(value =>
          zio.aws.transcribe.model.primitives.TranscriptionJobName(value)
        )
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val completionTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.completionTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.transcribe.model.LanguageCode.wrap(value))
    override val transcriptionJobStatus
        : Optional[zio.aws.transcribe.model.TranscriptionJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transcriptionJobStatus())
        .map(value =>
          zio.aws.transcribe.model.TranscriptionJobStatus.wrap(value)
        )
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.transcribe.model.primitives.FailureReason(value))
    override val outputLocationType
        : Optional[zio.aws.transcribe.model.OutputLocationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputLocationType())
        .map(value => zio.aws.transcribe.model.OutputLocationType.wrap(value))
    override val specialty: Optional[zio.aws.transcribe.model.Specialty] =
      zio.aws.core.internal
        .optionalFromNullable(impl.specialty())
        .map(value => zio.aws.transcribe.model.Specialty.wrap(value))
    override val contentIdentificationType
        : Optional[zio.aws.transcribe.model.MedicalContentIdentificationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentIdentificationType())
        .map(value =>
          zio.aws.transcribe.model.MedicalContentIdentificationType.wrap(value)
        )
    override val `type`: Optional[zio.aws.transcribe.model.Type] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.transcribe.model.Type.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJobSummary
  ): zio.aws.transcribe.model.MedicalTranscriptionJobSummary.ReadOnly =
    new Wrapper(impl)
}
