package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListCallAnalyticsCategoriesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    categories: Optional[
      Iterable[zio.aws.transcribe.model.CategoryProperties]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesResponse = {
    import ListCallAnalyticsCategoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        categories.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.categories)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.ListCallAnalyticsCategoriesResponse.ReadOnly =
    zio.aws.transcribe.model.ListCallAnalyticsCategoriesResponse
      .wrap(buildAwsValue())
}
object ListCallAnalyticsCategoriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.transcribe.model.ListCallAnalyticsCategoriesResponse =
      zio.aws.transcribe.model.ListCallAnalyticsCategoriesResponse(
        nextToken.map(value => value),
        categories.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def categories
        : Optional[List[zio.aws.transcribe.model.CategoryProperties.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getCategories: ZIO[Any, AwsError, List[
      zio.aws.transcribe.model.CategoryProperties.ReadOnly
    ]] = AwsError.unwrapOptionField("categories", categories)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesResponse
  ) extends zio.aws.transcribe.model.ListCallAnalyticsCategoriesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transcribe.model.primitives.NextToken(value))
    override val categories
        : Optional[List[zio.aws.transcribe.model.CategoryProperties.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.categories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.CategoryProperties.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesResponse
  ): zio.aws.transcribe.model.ListCallAnalyticsCategoriesResponse.ReadOnly =
    new Wrapper(impl)
}
