package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.{Uri, VocabularyName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateMedicalVocabularyRequest(
    vocabularyName: VocabularyName,
    languageCode: zio.aws.transcribe.model.LanguageCode,
    vocabularyFileUri: Uri,
    tags: Optional[Iterable[zio.aws.transcribe.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.CreateMedicalVocabularyRequest = {
    import CreateMedicalVocabularyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.CreateMedicalVocabularyRequest
      .builder()
      .vocabularyName(VocabularyName.unwrap(vocabularyName): java.lang.String)
      .languageCode(languageCode.unwrap)
      .vocabularyFileUri(Uri.unwrap(vocabularyFileUri): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.CreateMedicalVocabularyRequest.ReadOnly =
    zio.aws.transcribe.model.CreateMedicalVocabularyRequest
      .wrap(buildAwsValue())
}
object CreateMedicalVocabularyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.CreateMedicalVocabularyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.CreateMedicalVocabularyRequest =
      zio.aws.transcribe.model.CreateMedicalVocabularyRequest(
        vocabularyName,
        languageCode,
        vocabularyFileUri,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vocabularyName: VocabularyName
    def languageCode: zio.aws.transcribe.model.LanguageCode
    def vocabularyFileUri: Uri
    def tags: Optional[List[zio.aws.transcribe.model.Tag.ReadOnly]]
    def getVocabularyName: ZIO[Any, Nothing, VocabularyName] =
      ZIO.succeed(vocabularyName)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.transcribe.model.LanguageCode] =
      ZIO.succeed(languageCode)
    def getVocabularyFileUri: ZIO[Any, Nothing, Uri] =
      ZIO.succeed(vocabularyFileUri)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.CreateMedicalVocabularyRequest
  ) extends zio.aws.transcribe.model.CreateMedicalVocabularyRequest.ReadOnly {
    override val vocabularyName: VocabularyName =
      zio.aws.transcribe.model.primitives.VocabularyName(impl.vocabularyName())
    override val languageCode: zio.aws.transcribe.model.LanguageCode =
      zio.aws.transcribe.model.LanguageCode.wrap(impl.languageCode())
    override val vocabularyFileUri: Uri =
      zio.aws.transcribe.model.primitives.Uri(impl.vocabularyFileUri())
    override val tags: Optional[List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.CreateMedicalVocabularyRequest
  ): zio.aws.transcribe.model.CreateMedicalVocabularyRequest.ReadOnly =
    new Wrapper(impl)
}
