package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SentimentFilter(
    sentiments: Iterable[zio.aws.transcribe.model.SentimentValue],
    absoluteTimeRange: Optional[zio.aws.transcribe.model.AbsoluteTimeRange] =
      Optional.Absent,
    relativeTimeRange: Optional[zio.aws.transcribe.model.RelativeTimeRange] =
      Optional.Absent,
    participantRole: Optional[zio.aws.transcribe.model.ParticipantRole] =
      Optional.Absent,
    negate: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.SentimentFilter = {
    import SentimentFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.SentimentFilter
      .builder()
      .sentimentsWithStrings(sentiments.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(absoluteTimeRange.map(value => value.buildAwsValue()))(
        _.absoluteTimeRange
      )
      .optionallyWith(relativeTimeRange.map(value => value.buildAwsValue()))(
        _.relativeTimeRange
      )
      .optionallyWith(participantRole.map(value => value.unwrap))(
        _.participantRole
      )
      .optionallyWith(negate.map(value => value: java.lang.Boolean))(_.negate)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.SentimentFilter.ReadOnly =
    zio.aws.transcribe.model.SentimentFilter.wrap(buildAwsValue())
}
object SentimentFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.SentimentFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.SentimentFilter =
      zio.aws.transcribe.model.SentimentFilter(
        sentiments,
        absoluteTimeRange.map(value => value.asEditable),
        relativeTimeRange.map(value => value.asEditable),
        participantRole.map(value => value),
        negate.map(value => value)
      )
    def sentiments: List[zio.aws.transcribe.model.SentimentValue]
    def absoluteTimeRange
        : Optional[zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly]
    def relativeTimeRange
        : Optional[zio.aws.transcribe.model.RelativeTimeRange.ReadOnly]
    def participantRole: Optional[zio.aws.transcribe.model.ParticipantRole]
    def negate: Optional[Boolean]
    def getSentiments
        : ZIO[Any, Nothing, List[zio.aws.transcribe.model.SentimentValue]] =
      ZIO.succeed(sentiments)
    def getAbsoluteTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("absoluteTimeRange", absoluteTimeRange)
    def getRelativeTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.RelativeTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("relativeTimeRange", relativeTimeRange)
    def getParticipantRole
        : ZIO[Any, AwsError, zio.aws.transcribe.model.ParticipantRole] =
      AwsError.unwrapOptionField("participantRole", participantRole)
    def getNegate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("negate", negate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.SentimentFilter
  ) extends zio.aws.transcribe.model.SentimentFilter.ReadOnly {
    override val sentiments: List[zio.aws.transcribe.model.SentimentValue] =
      impl
        .sentiments()
        .asScala
        .map { item =>
          zio.aws.transcribe.model.SentimentValue.wrap(item)
        }
        .toList
    override val absoluteTimeRange
        : Optional[zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.absoluteTimeRange())
        .map(value => zio.aws.transcribe.model.AbsoluteTimeRange.wrap(value))
    override val relativeTimeRange
        : Optional[zio.aws.transcribe.model.RelativeTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relativeTimeRange())
        .map(value => zio.aws.transcribe.model.RelativeTimeRange.wrap(value))
    override val participantRole
        : Optional[zio.aws.transcribe.model.ParticipantRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.participantRole())
        .map(value => zio.aws.transcribe.model.ParticipantRole.wrap(value))
    override val negate: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.negate())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.SentimentFilter
  ): zio.aws.transcribe.model.SentimentFilter.ReadOnly = new Wrapper(impl)
}
