package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.TimestampMilliseconds
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NonTalkTimeFilter(
    threshold: Optional[TimestampMilliseconds] = Optional.Absent,
    absoluteTimeRange: Optional[zio.aws.transcribe.model.AbsoluteTimeRange] =
      Optional.Absent,
    relativeTimeRange: Optional[zio.aws.transcribe.model.RelativeTimeRange] =
      Optional.Absent,
    negate: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.NonTalkTimeFilter = {
    import NonTalkTimeFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.NonTalkTimeFilter
      .builder()
      .optionallyWith(
        threshold.map(value =>
          TimestampMilliseconds.unwrap(value): java.lang.Long
        )
      )(_.threshold)
      .optionallyWith(absoluteTimeRange.map(value => value.buildAwsValue()))(
        _.absoluteTimeRange
      )
      .optionallyWith(relativeTimeRange.map(value => value.buildAwsValue()))(
        _.relativeTimeRange
      )
      .optionallyWith(negate.map(value => value: java.lang.Boolean))(_.negate)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.NonTalkTimeFilter.ReadOnly =
    zio.aws.transcribe.model.NonTalkTimeFilter.wrap(buildAwsValue())
}
object NonTalkTimeFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.NonTalkTimeFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.NonTalkTimeFilter =
      zio.aws.transcribe.model.NonTalkTimeFilter(
        threshold.map(value => value),
        absoluteTimeRange.map(value => value.asEditable),
        relativeTimeRange.map(value => value.asEditable),
        negate.map(value => value)
      )
    def threshold: Optional[TimestampMilliseconds]
    def absoluteTimeRange
        : Optional[zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly]
    def relativeTimeRange
        : Optional[zio.aws.transcribe.model.RelativeTimeRange.ReadOnly]
    def negate: Optional[Boolean]
    def getThreshold: ZIO[Any, AwsError, TimestampMilliseconds] =
      AwsError.unwrapOptionField("threshold", threshold)
    def getAbsoluteTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("absoluteTimeRange", absoluteTimeRange)
    def getRelativeTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.RelativeTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("relativeTimeRange", relativeTimeRange)
    def getNegate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("negate", negate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.NonTalkTimeFilter
  ) extends zio.aws.transcribe.model.NonTalkTimeFilter.ReadOnly {
    override val threshold: Optional[TimestampMilliseconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.threshold())
        .map(value =>
          zio.aws.transcribe.model.primitives.TimestampMilliseconds(value)
        )
    override val absoluteTimeRange
        : Optional[zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.absoluteTimeRange())
        .map(value => zio.aws.transcribe.model.AbsoluteTimeRange.wrap(value))
    override val relativeTimeRange
        : Optional[zio.aws.transcribe.model.RelativeTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relativeTimeRange())
        .map(value => zio.aws.transcribe.model.RelativeTimeRange.wrap(value))
    override val negate: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.negate())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.NonTalkTimeFilter
  ): zio.aws.transcribe.model.NonTalkTimeFilter.ReadOnly = new Wrapper(impl)
}
