package zio.aws.transcribe.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{
  MaxResults,
  NextToken,
  TranscriptionJobName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListMedicalTranscriptionJobsRequest(
    status: Optional[zio.aws.transcribe.model.TranscriptionJobStatus] =
      Optional.Absent,
    jobNameContains: Optional[TranscriptionJobName] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest = {
    import ListMedicalTranscriptionJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        jobNameContains.map(value =>
          TranscriptionJobName.unwrap(value): java.lang.String
        )
      )(_.jobNameContains)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.ListMedicalTranscriptionJobsRequest.ReadOnly =
    zio.aws.transcribe.model.ListMedicalTranscriptionJobsRequest
      .wrap(buildAwsValue())
}
object ListMedicalTranscriptionJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.transcribe.model.ListMedicalTranscriptionJobsRequest =
      zio.aws.transcribe.model.ListMedicalTranscriptionJobsRequest(
        status.map(value => value),
        jobNameContains.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def status: Optional[zio.aws.transcribe.model.TranscriptionJobStatus]
    def jobNameContains: Optional[TranscriptionJobName]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.TranscriptionJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getJobNameContains: ZIO[Any, AwsError, TranscriptionJobName] =
      AwsError.unwrapOptionField("jobNameContains", jobNameContains)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest
  ) extends zio.aws.transcribe.model.ListMedicalTranscriptionJobsRequest.ReadOnly {
    override val status
        : Optional[zio.aws.transcribe.model.TranscriptionJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.transcribe.model.TranscriptionJobStatus.wrap(value)
        )
    override val jobNameContains: Optional[TranscriptionJobName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobNameContains())
        .map(value =>
          zio.aws.transcribe.model.primitives.TranscriptionJobName(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transcribe.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.transcribe.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest
  ): zio.aws.transcribe.model.ListMedicalTranscriptionJobsRequest.ReadOnly =
    new Wrapper(impl)
}
