package zio.aws.transcribe.model
import scala.jdk.CollectionConverters.*
sealed trait OutputLocationType {
  def unwrap
      : software.amazon.awssdk.services.transcribe.model.OutputLocationType
}
object OutputLocationType {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.OutputLocationType
  ): zio.aws.transcribe.model.OutputLocationType = value match {
    case software.amazon.awssdk.services.transcribe.model.OutputLocationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.OutputLocationType.CUSTOMER_BUCKET =>
      val r = CUSTOMER_BUCKET
      r
    case software.amazon.awssdk.services.transcribe.model.OutputLocationType.SERVICE_BUCKET =>
      val r = SERVICE_BUCKET
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribe.model.OutputLocationType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.OutputLocationType =
      software.amazon.awssdk.services.transcribe.model.OutputLocationType.UNKNOWN_TO_SDK_VERSION
  }
  case object CUSTOMER_BUCKET
      extends zio.aws.transcribe.model.OutputLocationType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.OutputLocationType =
      software.amazon.awssdk.services.transcribe.model.OutputLocationType.CUSTOMER_BUCKET
  }
  case object SERVICE_BUCKET
      extends zio.aws.transcribe.model.OutputLocationType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.OutputLocationType =
      software.amazon.awssdk.services.transcribe.model.OutputLocationType.SERVICE_BUCKET
  }
}
