package zio.aws.transcribe.model
import java.lang.Integer
import zio.ZIO
import zio.aws.transcribe.model.primitives.{
  MaxResults,
  NextToken,
  CallAnalyticsJobName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListCallAnalyticsJobsRequest(
    status: Option[zio.aws.transcribe.model.CallAnalyticsJobStatus] = None,
    jobNameContains: Option[CallAnalyticsJobName] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest = {
    import ListCallAnalyticsJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        jobNameContains.map(value =>
          CallAnalyticsJobName.unwrap(value): java.lang.String
        )
      )(_.jobNameContains)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.ListCallAnalyticsJobsRequest.ReadOnly =
    zio.aws.transcribe.model.ListCallAnalyticsJobsRequest.wrap(buildAwsValue())
}
object ListCallAnalyticsJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ListCallAnalyticsJobsRequest =
      zio.aws.transcribe.model.ListCallAnalyticsJobsRequest(
        status.map(value => value),
        jobNameContains.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def status: Option[zio.aws.transcribe.model.CallAnalyticsJobStatus]
    def jobNameContains: Option[CallAnalyticsJobName]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.CallAnalyticsJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getJobNameContains: ZIO[Any, AwsError, CallAnalyticsJobName] =
      AwsError.unwrapOptionField("jobNameContains", jobNameContains)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest
  ) extends zio.aws.transcribe.model.ListCallAnalyticsJobsRequest.ReadOnly {
    override val status
        : Option[zio.aws.transcribe.model.CallAnalyticsJobStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.transcribe.model.CallAnalyticsJobStatus.wrap(value))
    override val jobNameContains: Option[CallAnalyticsJobName] = scala
      .Option(impl.jobNameContains())
      .map(value =>
        zio.aws.transcribe.model.primitives.CallAnalyticsJobName(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.transcribe.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.transcribe.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest
  ): zio.aws.transcribe.model.ListCallAnalyticsJobsRequest.ReadOnly =
    new Wrapper(impl)
}
