package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.ModelName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateLanguageModelResponse(
    languageCode: Option[zio.aws.transcribe.model.CLMLanguageCode] = None,
    baseModelName: Option[zio.aws.transcribe.model.BaseModelName] = None,
    modelName: Option[ModelName] = None,
    inputDataConfig: Option[zio.aws.transcribe.model.InputDataConfig] = None,
    modelStatus: Option[zio.aws.transcribe.model.ModelStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.CreateLanguageModelResponse = {
    import CreateLanguageModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.CreateLanguageModelResponse
      .builder()
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(baseModelName.map(value => value.unwrap))(_.baseModelName)
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(inputDataConfig.map(value => value.buildAwsValue()))(
        _.inputDataConfig
      )
      .optionallyWith(modelStatus.map(value => value.unwrap))(_.modelStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.CreateLanguageModelResponse.ReadOnly =
    zio.aws.transcribe.model.CreateLanguageModelResponse.wrap(buildAwsValue())
}
object CreateLanguageModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.CreateLanguageModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.CreateLanguageModelResponse =
      zio.aws.transcribe.model.CreateLanguageModelResponse(
        languageCode.map(value => value),
        baseModelName.map(value => value),
        modelName.map(value => value),
        inputDataConfig.map(value => value.asEditable),
        modelStatus.map(value => value)
      )
    def languageCode: Option[zio.aws.transcribe.model.CLMLanguageCode]
    def baseModelName: Option[zio.aws.transcribe.model.BaseModelName]
    def modelName: Option[ModelName]
    def inputDataConfig
        : Option[zio.aws.transcribe.model.InputDataConfig.ReadOnly]
    def modelStatus: Option[zio.aws.transcribe.model.ModelStatus]
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.CLMLanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getBaseModelName
        : ZIO[Any, AwsError, zio.aws.transcribe.model.BaseModelName] =
      AwsError.unwrapOptionField("baseModelName", baseModelName)
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getInputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.InputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("inputDataConfig", inputDataConfig)
    def getModelStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.ModelStatus] =
      AwsError.unwrapOptionField("modelStatus", modelStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.CreateLanguageModelResponse
  ) extends zio.aws.transcribe.model.CreateLanguageModelResponse.ReadOnly {
    override val languageCode
        : Option[zio.aws.transcribe.model.CLMLanguageCode] = scala
      .Option(impl.languageCode())
      .map(value => zio.aws.transcribe.model.CLMLanguageCode.wrap(value))
    override val baseModelName: Option[zio.aws.transcribe.model.BaseModelName] =
      scala
        .Option(impl.baseModelName())
        .map(value => zio.aws.transcribe.model.BaseModelName.wrap(value))
    override val modelName: Option[ModelName] = scala
      .Option(impl.modelName())
      .map(value => zio.aws.transcribe.model.primitives.ModelName(value))
    override val inputDataConfig
        : Option[zio.aws.transcribe.model.InputDataConfig.ReadOnly] = scala
      .Option(impl.inputDataConfig())
      .map(value => zio.aws.transcribe.model.InputDataConfig.wrap(value))
    override val modelStatus: Option[zio.aws.transcribe.model.ModelStatus] =
      scala
        .Option(impl.modelStatus())
        .map(value => zio.aws.transcribe.model.ModelStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.CreateLanguageModelResponse
  ): zio.aws.transcribe.model.CreateLanguageModelResponse.ReadOnly =
    new Wrapper(impl)
}
