package zio.aws.transcribe.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{
  FailureReason,
  DateTime,
  MedicalMediaSampleRateHertz,
  TranscriptionJobName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class MedicalTranscriptionJob(
    medicalTranscriptionJobName: Option[TranscriptionJobName] = None,
    transcriptionJobStatus: Option[
      zio.aws.transcribe.model.TranscriptionJobStatus
    ] = None,
    languageCode: Option[zio.aws.transcribe.model.LanguageCode] = None,
    mediaSampleRateHertz: Option[MedicalMediaSampleRateHertz] = None,
    mediaFormat: Option[zio.aws.transcribe.model.MediaFormat] = None,
    media: Option[zio.aws.transcribe.model.Media] = None,
    transcript: Option[zio.aws.transcribe.model.MedicalTranscript] = None,
    startTime: Option[DateTime] = None,
    creationTime: Option[DateTime] = None,
    completionTime: Option[DateTime] = None,
    failureReason: Option[FailureReason] = None,
    settings: Option[zio.aws.transcribe.model.MedicalTranscriptionSetting] =
      None,
    contentIdentificationType: Option[
      zio.aws.transcribe.model.MedicalContentIdentificationType
    ] = None,
    specialty: Option[zio.aws.transcribe.model.Specialty] = None,
    `type`: Option[zio.aws.transcribe.model.Type] = None,
    tags: Option[Iterable[zio.aws.transcribe.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJob = {
    import MedicalTranscriptionJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJob
      .builder()
      .optionallyWith(
        medicalTranscriptionJobName.map(value =>
          TranscriptionJobName.unwrap(value): java.lang.String
        )
      )(_.medicalTranscriptionJobName)
      .optionallyWith(transcriptionJobStatus.map(value => value.unwrap))(
        _.transcriptionJobStatus
      )
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        mediaSampleRateHertz.map(value =>
          MedicalMediaSampleRateHertz.unwrap(value): Integer
        )
      )(_.mediaSampleRateHertz)
      .optionallyWith(mediaFormat.map(value => value.unwrap))(_.mediaFormat)
      .optionallyWith(media.map(value => value.buildAwsValue()))(_.media)
      .optionallyWith(transcript.map(value => value.buildAwsValue()))(
        _.transcript
      )
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        completionTime.map(value => DateTime.unwrap(value): Instant)
      )(_.completionTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .optionallyWith(contentIdentificationType.map(value => value.unwrap))(
        _.contentIdentificationType
      )
      .optionallyWith(specialty.map(value => value.unwrap))(_.specialty)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.MedicalTranscriptionJob.ReadOnly =
    zio.aws.transcribe.model.MedicalTranscriptionJob.wrap(buildAwsValue())
}
object MedicalTranscriptionJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.MedicalTranscriptionJob =
      zio.aws.transcribe.model.MedicalTranscriptionJob(
        medicalTranscriptionJobName.map(value => value),
        transcriptionJobStatus.map(value => value),
        languageCode.map(value => value),
        mediaSampleRateHertz.map(value => value),
        mediaFormat.map(value => value),
        media.map(value => value.asEditable),
        transcript.map(value => value.asEditable),
        startTime.map(value => value),
        creationTime.map(value => value),
        completionTime.map(value => value),
        failureReason.map(value => value),
        settings.map(value => value.asEditable),
        contentIdentificationType.map(value => value),
        specialty.map(value => value),
        `type`.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def medicalTranscriptionJobName: Option[TranscriptionJobName]
    def transcriptionJobStatus
        : Option[zio.aws.transcribe.model.TranscriptionJobStatus]
    def languageCode: Option[zio.aws.transcribe.model.LanguageCode]
    def mediaSampleRateHertz: Option[MedicalMediaSampleRateHertz]
    def mediaFormat: Option[zio.aws.transcribe.model.MediaFormat]
    def media: Option[zio.aws.transcribe.model.Media.ReadOnly]
    def transcript: Option[zio.aws.transcribe.model.MedicalTranscript.ReadOnly]
    def startTime: Option[DateTime]
    def creationTime: Option[DateTime]
    def completionTime: Option[DateTime]
    def failureReason: Option[FailureReason]
    def settings
        : Option[zio.aws.transcribe.model.MedicalTranscriptionSetting.ReadOnly]
    def contentIdentificationType
        : Option[zio.aws.transcribe.model.MedicalContentIdentificationType]
    def specialty: Option[zio.aws.transcribe.model.Specialty]
    def `type`: Option[zio.aws.transcribe.model.Type]
    def tags: Option[List[zio.aws.transcribe.model.Tag.ReadOnly]]
    def getMedicalTranscriptionJobName
        : ZIO[Any, AwsError, TranscriptionJobName] = AwsError.unwrapOptionField(
      "medicalTranscriptionJobName",
      medicalTranscriptionJobName
    )
    def getTranscriptionJobStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.TranscriptionJobStatus] =
      AwsError.unwrapOptionField(
        "transcriptionJobStatus",
        transcriptionJobStatus
      )
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getMediaSampleRateHertz
        : ZIO[Any, AwsError, MedicalMediaSampleRateHertz] =
      AwsError.unwrapOptionField("mediaSampleRateHertz", mediaSampleRateHertz)
    def getMediaFormat
        : ZIO[Any, AwsError, zio.aws.transcribe.model.MediaFormat] =
      AwsError.unwrapOptionField("mediaFormat", mediaFormat)
    def getMedia: ZIO[Any, AwsError, zio.aws.transcribe.model.Media.ReadOnly] =
      AwsError.unwrapOptionField("media", media)
    def getTranscript: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.MedicalTranscript.ReadOnly
    ] = AwsError.unwrapOptionField("transcript", transcript)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCompletionTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getSettings: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.MedicalTranscriptionSetting.ReadOnly
    ] = AwsError.unwrapOptionField("settings", settings)
    def getContentIdentificationType: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.MedicalContentIdentificationType
    ] = AwsError.unwrapOptionField(
      "contentIdentificationType",
      contentIdentificationType
    )
    def getSpecialty: ZIO[Any, AwsError, zio.aws.transcribe.model.Specialty] =
      AwsError.unwrapOptionField("specialty", specialty)
    def getType: ZIO[Any, AwsError, zio.aws.transcribe.model.Type] =
      AwsError.unwrapOptionField("type", `type`)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJob
  ) extends zio.aws.transcribe.model.MedicalTranscriptionJob.ReadOnly {
    override val medicalTranscriptionJobName: Option[TranscriptionJobName] =
      scala
        .Option(impl.medicalTranscriptionJobName())
        .map(value =>
          zio.aws.transcribe.model.primitives.TranscriptionJobName(value)
        )
    override val transcriptionJobStatus
        : Option[zio.aws.transcribe.model.TranscriptionJobStatus] = scala
      .Option(impl.transcriptionJobStatus())
      .map(value => zio.aws.transcribe.model.TranscriptionJobStatus.wrap(value))
    override val languageCode: Option[zio.aws.transcribe.model.LanguageCode] =
      scala
        .Option(impl.languageCode())
        .map(value => zio.aws.transcribe.model.LanguageCode.wrap(value))
    override val mediaSampleRateHertz: Option[MedicalMediaSampleRateHertz] =
      scala
        .Option(impl.mediaSampleRateHertz())
        .map(value =>
          zio.aws.transcribe.model.primitives.MedicalMediaSampleRateHertz(value)
        )
    override val mediaFormat: Option[zio.aws.transcribe.model.MediaFormat] =
      scala
        .Option(impl.mediaFormat())
        .map(value => zio.aws.transcribe.model.MediaFormat.wrap(value))
    override val media: Option[zio.aws.transcribe.model.Media.ReadOnly] = scala
      .Option(impl.media())
      .map(value => zio.aws.transcribe.model.Media.wrap(value))
    override val transcript
        : Option[zio.aws.transcribe.model.MedicalTranscript.ReadOnly] = scala
      .Option(impl.transcript())
      .map(value => zio.aws.transcribe.model.MedicalTranscript.wrap(value))
    override val startTime: Option[DateTime] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val creationTime: Option[DateTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val completionTime: Option[DateTime] = scala
      .Option(impl.completionTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.transcribe.model.primitives.FailureReason(value))
    override val settings: Option[
      zio.aws.transcribe.model.MedicalTranscriptionSetting.ReadOnly
    ] = scala
      .Option(impl.settings())
      .map(value =>
        zio.aws.transcribe.model.MedicalTranscriptionSetting.wrap(value)
      )
    override val contentIdentificationType
        : Option[zio.aws.transcribe.model.MedicalContentIdentificationType] =
      scala
        .Option(impl.contentIdentificationType())
        .map(value =>
          zio.aws.transcribe.model.MedicalContentIdentificationType.wrap(value)
        )
    override val specialty: Option[zio.aws.transcribe.model.Specialty] = scala
      .Option(impl.specialty())
      .map(value => zio.aws.transcribe.model.Specialty.wrap(value))
    override val `type`: Option[zio.aws.transcribe.model.Type] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.transcribe.model.Type.wrap(value))
    override val tags: Option[List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJob
  ): zio.aws.transcribe.model.MedicalTranscriptionJob.ReadOnly = new Wrapper(
    impl
  )
}
