package zio.aws.transcribe.model
import java.lang.Integer
import zio.ZIO
import zio.aws.transcribe.model.primitives.{
  MaxResults,
  NextToken,
  TranscriptionJobName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTranscriptionJobsRequest(
    status: Option[zio.aws.transcribe.model.TranscriptionJobStatus] = None,
    jobNameContains: Option[TranscriptionJobName] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest = {
    import ListTranscriptionJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        jobNameContains.map(value =>
          TranscriptionJobName.unwrap(value): java.lang.String
        )
      )(_.jobNameContains)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.ListTranscriptionJobsRequest.ReadOnly =
    zio.aws.transcribe.model.ListTranscriptionJobsRequest.wrap(buildAwsValue())
}
object ListTranscriptionJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ListTranscriptionJobsRequest =
      zio.aws.transcribe.model.ListTranscriptionJobsRequest(
        status.map(value => value),
        jobNameContains.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def status: Option[zio.aws.transcribe.model.TranscriptionJobStatus]
    def jobNameContains: Option[TranscriptionJobName]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.TranscriptionJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getJobNameContains: ZIO[Any, AwsError, TranscriptionJobName] =
      AwsError.unwrapOptionField("jobNameContains", jobNameContains)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest
  ) extends zio.aws.transcribe.model.ListTranscriptionJobsRequest.ReadOnly {
    override val status
        : Option[zio.aws.transcribe.model.TranscriptionJobStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.transcribe.model.TranscriptionJobStatus.wrap(value))
    override val jobNameContains: Option[TranscriptionJobName] = scala
      .Option(impl.jobNameContains())
      .map(value =>
        zio.aws.transcribe.model.primitives.TranscriptionJobName(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.transcribe.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.transcribe.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest
  ): zio.aws.transcribe.model.ListTranscriptionJobsRequest.ReadOnly =
    new Wrapper(impl)
}
